/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.plugin;

import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.service.RuleService;
import io.meeds.portal.plugin.AclPlugin;
import jakarta.annotation.PostConstruct;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.security.Identity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RuleAclPlugin
implements AclPlugin {
    public static final String OBJECT_TYPE = "rule";
    @Autowired
    private RuleService ruleService;
    @Autowired
    private PortalContainer container;

    @PostConstruct
    public void init() {
        ((UserACL)this.container.getComponentInstanceOfType(UserACL.class)).addAclPlugin((AclPlugin)this);
    }

    public String getObjectType() {
        return OBJECT_TYPE;
    }

    public boolean hasPermission(String objectId, String permissionType, Identity identity) {
        String username = identity == null ? null : identity.getUserId();
        RuleDTO rule = this.ruleService.findRuleById(Long.parseLong(objectId));
        return switch (permissionType) {
            case "VIEW" -> this.ruleService.canViewRule(rule, username);
            case "EDIT", "DELETE" -> this.ruleService.canEditRule(rule, username);
            default -> false;
        };
    }
}

