/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.RuntimeDelegate;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.ObjectFactory;
import org.exoplatform.services.rest.PerRequestObjectFactory;
import org.exoplatform.services.rest.SingletonObjectFactory;
import org.exoplatform.services.rest.impl.ApplicationRegistry;
import org.exoplatform.services.rest.impl.ResourceListener;
import org.exoplatform.services.rest.impl.ResourcePublicationException;
import org.exoplatform.services.rest.impl.RuntimeDelegateImpl;
import org.exoplatform.services.rest.impl.method.MethodInvokerFactory;
import org.exoplatform.services.rest.impl.resource.AbstractResourceDescriptorImpl;
import org.exoplatform.services.rest.impl.resource.ResourceDescriptorValidator;
import org.exoplatform.services.rest.resource.AbstractResourceDescriptor;
import org.exoplatform.services.rest.resource.ResourceDescriptorVisitor;
import org.exoplatform.services.rest.uri.UriPattern;
import org.picocontainer.Startable;

public class ResourceBinder
implements Startable {
    public static final String RESOURCE_EXPIRED = "resource.expiration.date";
    private static final Log LOG = ExoLogger.getLogger((String)"exo.ws.rest.core.ResourceBinder");
    protected static final Comparator<ObjectFactory<AbstractResourceDescriptor>> RESOURCE_COMPARATOR = new Comparator<ObjectFactory<AbstractResourceDescriptor>>(){

        @Override
        public int compare(ObjectFactory<AbstractResourceDescriptor> o1, ObjectFactory<AbstractResourceDescriptor> o2) {
            return UriPattern.URIPATTERN_COMPARATOR.compare(o1.getObjectModel().getUriPattern(), o2.getObjectModel().getUriPattern());
        }
    };
    protected boolean cleanerStop = false;
    protected final ResourceDescriptorVisitor rdv = ResourceDescriptorValidator.getInstance();
    @Deprecated
    protected final RuntimeDelegate rd;
    protected final MethodInvokerFactory invokerFactory;
    protected final List<ObjectFactory<AbstractResourceDescriptor>> rootResources = Collections.synchronizedList(new ArrayList());
    protected final List<ResourceListener> resourceListeners = new ArrayList<ResourceListener>();
    protected final ExoContainer container;
    protected final String containerName;

    public ResourceBinder(ExoContainerContext containerContext) throws Exception {
        this(containerContext, null);
    }

    public ResourceBinder(ExoContainerContext containerContext, MethodInvokerFactory invokerFactory) throws Exception {
        this.invokerFactory = invokerFactory;
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
        this.rd = RuntimeDelegate.getInstance();
        this.container = containerContext.getContainer();
        this.containerName = containerContext.getName();
    }

    public void addApplication(Application application) {
        ApplicationRegistry appRegistry = (ApplicationRegistry)this.container.getComponentInstanceOfType(ApplicationRegistry.class);
        appRegistry.addApplication(application);
    }

    public void addResource(Class<?> resourceClass, MultivaluedMap<String, String> properties) {
        Path path = resourceClass.getAnnotation(Path.class);
        if (path == null) {
            throw new ResourcePublicationException("Resource class " + resourceClass.getName() + " it is not root resource. Path annotation javax.ws.rs.Path is not specified for this class.");
        }
        try {
            AbstractResourceDescriptorImpl descriptor = new AbstractResourceDescriptorImpl(resourceClass, this.invokerFactory);
            descriptor.accept(this.rdv);
            if (properties != null) {
                descriptor.getProperties().putAll(properties);
            }
            this.addResource(new PerRequestObjectFactory<AbstractResourceDescriptor>(descriptor));
        }
        catch (Exception e) {
            throw new ResourcePublicationException(e.getMessage());
        }
    }

    public void addResource(Object resource, MultivaluedMap<String, String> properties) {
        Path path = resource.getClass().getAnnotation(Path.class);
        if (path == null) {
            throw new ResourcePublicationException("Resource class " + resource.getClass().getName() + " it is not root resource. Path annotation javax.ws.rs.Path is not specified for this class.");
        }
        try {
            AbstractResourceDescriptorImpl descriptor = new AbstractResourceDescriptorImpl(resource, this.invokerFactory);
            descriptor.accept(this.rdv);
            if (properties != null) {
                descriptor.getProperties().putAll(properties);
            }
            this.addResource(new SingletonObjectFactory<AbstractResourceDescriptor>(descriptor, resource));
        }
        catch (Exception e) {
            throw new ResourcePublicationException(e.getMessage());
        }
    }

    public void addResource(ObjectFactory<AbstractResourceDescriptor> resourceFactory) {
        UriPattern pattern = resourceFactory.getObjectModel().getUriPattern();
        for (ObjectFactory<AbstractResourceDescriptor> resource : this.rootResources) {
            if (!resource.getObjectModel().getUriPattern().equals(resourceFactory.getObjectModel().getUriPattern())) continue;
            throw new ResourcePublicationException("Resource class " + resourceFactory.getObjectModel().getObjectClass().getName() + " can't be registered. Resource class " + resource.getObjectModel().getObjectClass().getName() + " with the same pattern " + String.valueOf(pattern) + " already registered.");
        }
        this.rootResources.add(resourceFactory);
        Collections.sort(this.rootResources, RESOURCE_COMPARATOR);
        for (ResourceListener listener : this.resourceListeners) {
            listener.resourceAdded(resourceFactory.getObjectModel());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Add resource: " + String.valueOf(resourceFactory.getObjectModel())));
        }
    }

    public void addResourceListener(ResourceListener listener) {
        this.resourceListeners.add(listener);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Resource listener added: " + String.valueOf(listener)));
        }
    }

    public boolean bind(Class<?> resourceClass) {
        try {
            this.addResource(resourceClass, null);
            return true;
        }
        catch (ResourcePublicationException e) {
            LOG.warn((Object)e.getMessage());
            return false;
        }
    }

    public boolean bind(Object resource) {
        try {
            this.addResource(resource, null);
            return true;
        }
        catch (ResourcePublicationException e) {
            LOG.warn((Object)e.getMessage());
            return false;
        }
    }

    public void clear() {
        this.rootResources.clear();
    }

    public ObjectFactory<AbstractResourceDescriptor> getMatchedResource(String requestPath, List<String> parameterValues) {
        ObjectFactory<AbstractResourceDescriptor> resourceFactory = null;
        for (ObjectFactory<AbstractResourceDescriptor> resource : this.rootResources) {
            int subresnum;
            int len;
            if (!resource.getObjectModel().getUriPattern().match(requestPath, parameterValues) || parameterValues.get((len = parameterValues.size()) - 1) != null && !parameterValues.get(len - 1).equals("/") && (subresnum = resource.getObjectModel().getSubResourceMethods().size() + resource.getObjectModel().getSubResourceLocators().size()) == 0) continue;
            resourceFactory = resource;
            break;
        }
        return resourceFactory;
    }

    public List<ObjectFactory<AbstractResourceDescriptor>> getResources() {
        return this.rootResources;
    }

    @Deprecated
    public List<AbstractResourceDescriptor> getRootResources() {
        ArrayList<AbstractResourceDescriptor> l = new ArrayList<AbstractResourceDescriptor>(this.rootResources.size());
        for (ObjectFactory<AbstractResourceDescriptor> f : this.rootResources) {
            l.add(f.getObjectModel());
        }
        return l;
    }

    public int getSize() {
        return this.rootResources.size();
    }

    public ObjectFactory<AbstractResourceDescriptor> removeResource(Class clazz) {
        ObjectFactory<AbstractResourceDescriptor> resource = null;
        Iterator<ObjectFactory<AbstractResourceDescriptor>> iter = this.rootResources.iterator();
        while (iter.hasNext() && resource == null) {
            ObjectFactory<AbstractResourceDescriptor> next = iter.next();
            Class<?> resourceClass = next.getObjectModel().getObjectClass();
            if (!clazz.equals(resourceClass)) continue;
            iter.remove();
            resource = next;
        }
        if (resource != null) {
            for (ResourceListener listener : this.resourceListeners) {
                listener.resourceRemoved((AbstractResourceDescriptor)resource.getObjectModel());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Remove resource: " + String.valueOf(resource.getObjectModel())));
            }
        }
        return resource;
    }

    public ObjectFactory<AbstractResourceDescriptor> removeResource(String path) {
        ObjectFactory<AbstractResourceDescriptor> resource = null;
        UriPattern pattern = new UriPattern(path);
        Iterator<ObjectFactory<AbstractResourceDescriptor>> iter = this.rootResources.iterator();
        while (iter.hasNext() && resource == null) {
            ObjectFactory<AbstractResourceDescriptor> next = iter.next();
            UriPattern resourcePattern = next.getObjectModel().getUriPattern();
            if (!pattern.equals(resourcePattern)) continue;
            iter.remove();
            resource = next;
        }
        if (resource != null) {
            for (ResourceListener listener : this.resourceListeners) {
                listener.resourceRemoved((AbstractResourceDescriptor)resource.getObjectModel());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Remove resource: " + String.valueOf(resource.getObjectModel())));
            }
        }
        return resource;
    }

    public boolean unbind(Class clazz) {
        return null != this.removeResource(clazz);
    }

    public boolean unbind(String path) {
        return null != this.removeResource(path);
    }

    public void start() {
        this.startResourceCleaner();
    }

    public void stop() {
        this.cleanerStop = true;
    }

    protected void startResourceCleaner() {
        Thread thread = new Thread((Runnable)new ResourceCleaner(60), "Resource Cleaner " + this.containerName);
        thread.setDaemon(true);
        thread.start();
    }

    protected class ResourceCleaner
    implements Runnable {
        private final int cleanerDelay;

        public ResourceCleaner(int cleanerDelay) {
            this.cleanerDelay = cleanerDelay;
        }

        @Override
        public void run() {
            while (!ResourceBinder.this.cleanerStop) {
                try {
                    Thread.sleep((long)this.cleanerDelay * 1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (ResourceBinder.this.cleanerStop) continue;
                this.processResources();
            }
        }

        protected void processResources() {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Start resource cleaner");
            }
            Iterator<ObjectFactory<AbstractResourceDescriptor>> iter = ResourceBinder.this.rootResources.iterator();
            while (iter.hasNext()) {
                ObjectFactory<AbstractResourceDescriptor> next = iter.next();
                List<String> str = next.getObjectModel().getProperty(ResourceBinder.RESOURCE_EXPIRED);
                long expirationDate = -1L;
                if (str != null && str.size() > 0) {
                    try {
                        expirationDate = Long.parseLong(str.get(0));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (expirationDate <= 0L || expirationDate >= System.currentTimeMillis()) continue;
                iter.remove();
                for (ResourceListener listener : ResourceBinder.this.resourceListeners) {
                    listener.resourceRemoved(next.getObjectModel());
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Remove expired resource: " + String.valueOf(next.getObjectModel())));
            }
        }
    }
}

