/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.portal;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UISiteBody;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;

@ComponentConfig
public class UISharedLayout
extends UIContainer {
    private String metaPortal;

    @Override
    public List<UIComponent> getChildren() {
        PortalRequestContext portalRequestContext = PortalRequestContext.getCurrentInstance();
        if (this.isShowSharedLayout(portalRequestContext)) {
            return this.getSharedLayoutChildren();
        }
        return this.getSiteLayoutChildren();
    }

    public boolean isShowSharedLayout(PortalRequestContext requestContext) {
        boolean showSharedLayout = !requestContext.isHideSharedLayout() && !this.hidePageSharedLayout(requestContext.getUiPage());
        UserPortalConfig userPortalConfig = requestContext.getUserPortalConfig();
        if (userPortalConfig != null && userPortalConfig.getPortalConfig() != null) {
            showSharedLayout = showSharedLayout && requestContext.getSiteType() != SiteType.GROUP_TEMPLATE && requestContext.getSiteType() != SiteType.PORTAL_TEMPLATE && requestContext.getSiteType() != SiteType.DRAFT && (requestContext.getSiteType() != SiteType.PORTAL || this.showSiteSharedLayout(userPortalConfig.getPortalConfig()) || this.showPageSharedLayout(requestContext.getUiPage()));
        }
        return showSharedLayout;
    }

    protected List<UIComponent> getSiteLayoutChildren() {
        UISiteBody uiSiteBody = this.findFirstComponentOfType(UISiteBody.class, this.getSharedLayoutChildren());
        return Collections.singletonList(uiSiteBody);
    }

    protected List<UIComponent> getSharedLayoutChildren() {
        return super.getChildren();
    }

    private boolean showSiteSharedLayout(PortalConfig site) {
        return StringUtils.equals((CharSequence)site.getName(), (CharSequence)this.getMataPortal()) || site.isDisplayed();
    }

    private boolean hidePageSharedLayout(UIPage uiPage) {
        return uiPage != null && uiPage.isHideSharedLayout();
    }

    private boolean showPageSharedLayout(UIPage uiPage) {
        return uiPage != null && !uiPage.isHideSharedLayout() && uiPage.isShowSharedLayout();
    }

    private String getMataPortal() {
        if (this.metaPortal == null) {
            this.metaPortal = PortalRequestContext.getCurrentInstance().getMetaPortal();
        }
        return this.metaPortal;
    }
}

