/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.lock;

import io.meeds.wallet.lock.Lock;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.StampedLock;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class LockAspect {
    private static final Map<String, StampedLock> LOCKS = new HashMap<String, StampedLock>();
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ LockAspect ajc$perSingletonInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="execution(* *(..)) && @annotation(io.meeds.wallet.lock.Lock)")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Method method = methodSignature.getMethod();
        Lock annotation = method.getAnnotation(Lock.class);
        String id = annotation.id();
        if (StringUtils.isBlank((CharSequence)id)) {
            id = method.toString();
        }
        StampedLock lock = LockAspect.LOCKS.computeIfAbsent(id, key -> new StampedLock());
        long stamp = lock.tryWriteLock(annotation.duration(), annotation.timeUnit());
        try {
            Object object = point.proceed();
            return object;
        }
        finally {
            lock.unlock(stamp);
        }
    }

    static {
        try {
            LockAspect.ajc$perSingletonInstance = new LockAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    public static LockAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("io.meeds.wallet.lock.LockAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

