/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.impl.container;

import org.gatein.pc.portlet.container.PortletFilter;
import org.gatein.pc.portlet.container.PortletFilterContext;
import org.gatein.pc.portlet.container.managed.LifeCycleStatus;
import org.gatein.pc.portlet.container.managed.ManagedObjectRegistryEventListener;
import org.gatein.pc.portlet.container.managed.ManagedPortletFilter;
import org.gatein.pc.portlet.container.object.PortletFilterObject;
import org.gatein.pc.portlet.impl.container.DependencyNotResolvedException;
import org.gatein.pc.portlet.impl.container.LifeCycle;
import org.gatein.pc.portlet.impl.container.PortletApplicationLifeCycle;
import org.gatein.pc.portlet.impl.container.PortletContainerLifeCycle;

public class PortletFilterLifeCycle
extends LifeCycle
implements ManagedPortletFilter {
    private PortletApplicationLifeCycle portletApplicationLifeCycle;
    final PortletFilterContext portletFilterContext;
    final PortletFilterObject portletFilter;

    PortletFilterLifeCycle(PortletApplicationLifeCycle portletApplicationLifeCycle, PortletFilterContext portletFilterContext, PortletFilterObject portletFilter) {
        this.portletApplicationLifeCycle = portletApplicationLifeCycle;
        this.portletFilterContext = portletFilterContext;
        this.portletFilter = portletFilter;
    }

    @Override
    protected void invokeCreate() throws Exception {
        if (this.portletApplicationLifeCycle.getStatus().getStage() < LifeCycleStatus.CREATED.getStage()) {
            throw new DependencyNotResolvedException("The parent application is not created");
        }
        this.portletFilter.create();
    }

    @Override
    protected void invokeStart() throws Exception {
        if (this.portletApplicationLifeCycle.getStatus().getStage() < LifeCycleStatus.STARTED.getStage()) {
            throw new DependencyNotResolvedException("The parent application is not started");
        }
        this.portletFilter.start();
    }

    @Override
    protected void promoteDependents(LifeCycleStatus to) {
        for (PortletContainerLifeCycle portletContainerLifeCycle : this.portletApplicationLifeCycle.getDependencies(this)) {
            portletContainerLifeCycle.promote(to);
        }
    }

    @Override
    protected void demoteDependents(LifeCycleStatus to) {
        for (PortletContainerLifeCycle portletContainerLifeCycle : this.portletApplicationLifeCycle.getDependencies(this)) {
            portletContainerLifeCycle.demote(to);
        }
    }

    @Override
    protected void invokeStop() {
        this.portletFilter.stop();
    }

    @Override
    protected void invokeDestroy() {
        this.portletFilter.destroy();
    }

    @Override
    public String getId() {
        return this.portletFilter.getId();
    }

    @Override
    public PortletApplicationLifeCycle getManagedPortletApplication() {
        return this.portletApplicationLifeCycle;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.portletFilter.getId() + "]";
    }

    @Override
    public PortletFilter getPortletFilter() {
        return this.portletFilter;
    }

    @Override
    protected ManagedObjectRegistryEventListener getListener() {
        return this.portletApplicationLifeCycle.getListener();
    }
}

