/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.core.api.controller;

import java.util.Map;
import java.util.Set;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.management.api.ExternalContext;
import org.gatein.management.api.ManagedDescription;
import org.gatein.management.api.ManagedResource;
import org.gatein.management.api.ManagementService;
import org.gatein.management.api.PathAddress;
import org.gatein.management.api.RuntimeContext;
import org.gatein.management.api.binding.BindingProvider;
import org.gatein.management.api.controller.ManagedRequest;
import org.gatein.management.api.controller.ManagedResponse;
import org.gatein.management.api.controller.ManagementController;
import org.gatein.management.api.exceptions.OperationException;
import org.gatein.management.api.exceptions.ResourceNotFoundException;
import org.gatein.management.api.model.ModelValue;
import org.gatein.management.api.operation.OperationContext;
import org.gatein.management.api.operation.OperationHandler;
import org.gatein.management.api.operation.ResultHandler;
import org.gatein.management.api.operation.model.NamedDescription;
import org.gatein.management.api.operation.model.ReadResourceModel;
import org.gatein.management.core.api.controller.DeprecatedManagedRequest;
import org.gatein.management.core.api.controller.FailureResponse;
import org.gatein.management.core.api.controller.SuccessfulResponse;
import org.gatein.management.core.api.model.DmrModelProvider;
import org.gatein.management.core.api.operation.BasicResultHandler;
import org.gatein.management.core.api.operation.OperationContextImpl;

public class SimpleManagementController
implements ManagementController {
    private static final Logger log = LoggerFactory.getLogger(SimpleManagementController.class);
    private final ManagementService managementService;
    private final RuntimeContext runtimeContext;
    private final ExternalContext externalContext;
    private ManagedResource rootResource;

    public SimpleManagementController(ManagementService managementService, RuntimeContext runtimeContext, ExternalContext externalContext) {
        this.managementService = managementService;
        this.runtimeContext = runtimeContext;
        this.externalContext = externalContext;
    }

    public ManagedResponse execute(ManagedRequest request) throws ResourceNotFoundException, OperationException {
        ManagedResource root;
        if (request.getAttributes().containsKey("reload-extensions")) {
            this.managementService.reloadExtensions();
            this.rootResource = this.managementService.getManagedResource(PathAddress.empty());
        }
        if ("read-config-as-xml".equals(request.getOperationName())) {
            log.warn((Object)"read-config-as-xml is deprecated. Please use read-config instead with proper content type.");
            request = new DeprecatedManagedRequest(request);
        }
        PathAddress address = request.getAddress();
        String operationName = request.getOperationName();
        boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug((Object)("Executing request for operation " + operationName + " at address " + address));
        }
        if ((root = this.getRootResource()).getSubResource(address) == null) {
            throw new ResourceNotFoundException("Could not locate managed resource for address '" + address + "'");
        }
        OperationHandler operationHandler = root.getOperationHandler(address, operationName);
        if (operationHandler != null) {
            String componentName = address.size() >= 1 ? address.get(0) : null;
            BindingProvider bindingProvider = this.managementService.getBindingProvider(componentName);
            DmrModelProvider modelProvider = DmrModelProvider.INSTANCE;
            BasicResultHandler resultHandler = new BasicResultHandler();
            operationHandler.execute((OperationContext)new OperationContextImpl(request, root, this.runtimeContext, this.externalContext, bindingProvider, modelProvider), (ResultHandler)resultHandler);
            if (resultHandler.getFailureDescription() != null) {
                return new FailureResponse((ModelValue)modelProvider.newModel().set(resultHandler.getFailureDescription()));
            }
            if (resultHandler.getFailure() != null) {
                return new FailureResponse(resultHandler.getFailure());
            }
            Object result = resultHandler.getResult();
            if (result instanceof ReadResourceModel) {
                ReadResourceModel readResource = (ReadResourceModel)result;
                if (!readResource.isChildDescriptionsSet()) {
                    this.populateChildDescriptions(root, address, readResource);
                }
                if (readResource.getOperations().isEmpty()) {
                    Map descriptions = root.getOperationDescriptions(address);
                    for (Map.Entry desc : descriptions.entrySet()) {
                        readResource.addOperation(new NamedDescription((String)desc.getKey(), ((ManagedDescription)desc.getValue()).getDescription()));
                    }
                }
            }
            return new SuccessfulResponse<Object>(bindingProvider, result, request.getContentType());
        }
        throw new OperationException(operationName, "Operation '" + operationName + "' not found for address '" + address + "'");
    }

    private void populateChildDescriptions(ManagedResource root, PathAddress address, ReadResourceModel readResource) {
        ManagedResource currentResource = root.getSubResource(address);
        Set subResourceNames = currentResource.getSubResourceNames(PathAddress.empty());
        if (!readResource.getChildren().isEmpty() && subResourceNames.isEmpty()) {
            for (String childName : readResource.getChildren()) {
                readResource.setChildDescription(childName, currentResource.getResourceDescription(PathAddress.empty()).getDescription());
            }
        } else {
            for (String subResourceName : subResourceNames) {
                ManagedResource subResource = currentResource.getSubResource(subResourceName);
                for (String childName : readResource.getChildren()) {
                    ManagedResource mr = root.getSubResource(address.append(childName));
                    if (mr != subResource && mr != currentResource) continue;
                    readResource.setChildDescription(childName, mr.getResourceDescription(PathAddress.empty()).getDescription());
                }
            }
        }
    }

    private ManagedResource getRootResource() {
        if (this.rootResource == null) {
            this.rootResource = this.managementService.getManagedResource(PathAddress.EMPTY_ADDRESS);
        }
        return this.rootResource;
    }
}

