/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.crowdin.gamification.rest;

import io.meeds.crowdin.gamification.model.RemoteDirectory;
import io.meeds.crowdin.gamification.model.RemoteProject;
import io.meeds.crowdin.gamification.model.WebHook;
import io.meeds.crowdin.gamification.rest.builder.WebHookBuilder;
import io.meeds.crowdin.gamification.rest.model.WebHookList;
import io.meeds.crowdin.gamification.rest.model.WebHookRestEntity;
import io.meeds.crowdin.gamification.services.WebhookService;
import io.meeds.crowdin.gamification.storage.CrowdinConsumerStorage;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import javax.ws.rs.core.Response;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"hooks"})
@Tag(name="hooks", description="An endpoint to manage crowdin webhooks")
public class HooksManagementRest {
    public static final String CROWDIN_HOOK_NOT_FOUND = "The Crowdin hook doesn't exit";
    @Autowired
    private WebhookService webhookService;
    @Autowired
    private CrowdinConsumerStorage crowdinConsumerStorage;

    @GetMapping
    @Secured(value={"users"})
    @Operation(summary="Retrieves the list Crowdin webHooks", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public WebHookList getWebHooks(@Parameter(description="Offset") @RequestParam(value="offset") int offset, @Parameter(description="Query results limit", required=true) @RequestParam(value="limit") int limit, @Parameter(description="force update remote project info") @RequestParam(value="forceUpdate", defaultValue="false", required=false) boolean forceUpdate, @Parameter(description="Include languages") @Schema(defaultValue="false") @RequestParam(value="includeLanguages") boolean includeLanguages) {
        WebHookList webHookList = new WebHookList();
        List<WebHookRestEntity> webHookRestEntities = this.getWebHookRestEntities(includeLanguages, forceUpdate);
        webHookList.setWebhooks(webHookRestEntities);
        webHookList.setOffset(offset);
        webHookList.setLimit(limit);
        return webHookList;
    }

    @GetMapping(value={"{webHookId}"})
    @Secured(value={"rewarding"})
    @Operation(summary="Retrieves a webHook by its technical identifier", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Not found"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="503", description="Service unavailable")})
    public WebHook getWebHookById(HttpServletRequest request, @Parameter(description="WebHook technical identifier", required=true) @PathVariable(value="webHookId") long webHookId) {
        if (webHookId == 0L) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "WebHook Id must be not null");
        }
        try {
            return this.webhookService.getWebhookId(webHookId, request.getRemoteUser());
        }
        catch (IllegalArgumentException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, e.getMessage());
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, e.getMessage());
        }
    }

    @GetMapping(value={"{projectId}/directories"})
    @Secured(value={"users"})
    @Operation(summary="Retrieves a list of project directories from crowdin", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Not found"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="503", description="Service unavailable")})
    public List<RemoteDirectory> getProjectDirectories(HttpServletRequest request, @Parameter(description="Remote project identifier", required=true) @PathVariable(value="projectId") long projectId, @Parameter(description="Query Offset") @RequestParam(value="offset", required=false, defaultValue="0") int offset, @Parameter(description="Query results limit") @RequestParam(value="limit", required=false, defaultValue="0") int limit) {
        try {
            return this.webhookService.getProjectDirectories(projectId, request.getRemoteUser(), offset, limit);
        }
        catch (IllegalArgumentException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, e.getMessage());
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, e.getMessage());
        }
    }

    @GetMapping(value={"projects"})
    @Secured(value={"rewarding"})
    @Operation(summary="Retrieves a list of projects from crowdin", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Not found"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="503", description="Service unavailable")})
    public List<RemoteProject> getProjects(@Parameter(description="Crowdin access token") @RequestParam(value="accessToken") String accessToken, @Parameter(description="WebHook technical identifier") @RequestParam(value="hookId") String webHookId) {
        try {
            if (webHookId != null && !webHookId.isEmpty()) {
                return this.webhookService.getProjectsFromWebhookId(Long.parseLong(webHookId));
            }
            return this.webhookService.getProjects(accessToken);
        }
        catch (IllegalArgumentException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, e.getMessage());
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, e.getMessage());
        }
    }

    @PostMapping
    @Secured(value={"rewarding"})
    @Operation(summary="Create a project webhook for Remote Crowdin connector.", description="Create a project webhook for Remote Crowdin connector.", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="404", description="Not found"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="409", description="Conflict"), @ApiResponse(responseCode="503", description="Service unavailable")})
    public ResponseEntity<Object> createWebhookHook(HttpServletRequest request, @Parameter(description="Crowdin project id", required=true) @RequestParam(value="projectId") Long projectId, @Parameter(description="Crowdin project name", required=true) @RequestParam(value="projectName") String projectName, @Parameter(description="Crowdin personal access token", required=true) @RequestParam(value="accessToken") String accessToken) {
        try {
            this.webhookService.createWebhook(projectId, projectName, accessToken, request.getRemoteUser());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).build();
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, e.getMessage());
        }
        catch (ObjectAlreadyExistsException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, e.getMessage());
        }
    }

    @PatchMapping
    @Secured(value={"rewarding"})
    @Operation(summary="Update a project webhook personal access token.", description="Update a project webhook personal access token.", method="PATCH")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Updated"), @ApiResponse(responseCode="404", description="Not found"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="409", description="Conflict"), @ApiResponse(responseCode="503", description="Service unavailable")})
    public Response updateWebHookAccessToken(HttpServletRequest request, @Parameter(description="webHook id", required=true) @RequestParam(value="webHookId") long webHookId, @Parameter(description="Crowdin personal access token", required=true) @RequestParam(value="accessToken") String accessToken) {
        if (webHookId <= 0L) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "'webHookId' must be positive");
        }
        try {
            this.webhookService.updateWebHookAccessToken(webHookId, accessToken, request.getRemoteUser());
            return Response.status((Response.Status)Response.Status.CREATED).build();
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, e.getMessage());
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, CROWDIN_HOOK_NOT_FOUND);
        }
    }

    @DeleteMapping(value={"{projectId}"})
    @Secured(value={"rewarding"})
    @Operation(summary="Deletes crowdin project webhook", description="Deletes crowdin project webhook", method="DELETE")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Not found"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="503", description="Service unavailable")})
    public void deleteWebhookHook(HttpServletRequest request, @Parameter(description="Crowdin project id", required=true) @PathVariable(value="projectId") long projectId) {
        if (projectId <= 0L) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "'hookName' parameter is mandatory");
        }
        try {
            this.webhookService.deleteWebhook(projectId, request.getRemoteUser());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, e.getMessage());
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, CROWDIN_HOOK_NOT_FOUND);
        }
    }

    private List<WebHookRestEntity> getWebHookRestEntities(boolean includeLanguages, boolean forceUpdate) {
        List<WebHook> webHooks = this.webhookService.getWebhooks(0, 20, forceUpdate);
        return WebHookBuilder.toRestEntities(this.crowdinConsumerStorage, webHooks, includeLanguages);
    }
}

