/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.crowdin.gamification.rest.builder;

import io.meeds.crowdin.gamification.model.RemoteProject;
import io.meeds.crowdin.gamification.model.WebHook;
import io.meeds.crowdin.gamification.rest.model.WebHookRestEntity;
import io.meeds.crowdin.gamification.storage.CrowdinConsumerStorage;
import java.util.Collection;
import java.util.List;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.springframework.stereotype.Component;

@Component
public class WebHookBuilder {
    private static final Log LOG = ExoLogger.getLogger(WebHookBuilder.class);

    private WebHookBuilder() {
    }

    public static WebHookRestEntity toRestEntity(CrowdinConsumerStorage crowdinConsumerStorage, WebHook webHook, boolean includeLanguages) {
        if (webHook == null) {
            return null;
        }
        RemoteProject remoteProject = null;
        try {
            remoteProject = crowdinConsumerStorage.retrieveRemoteProject(webHook.getProjectId(), includeLanguages, webHook.getToken());
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)e);
        }
        return new WebHookRestEntity(webHook.getId(), webHook.getWebhookId(), webHook.getProjectId(), webHook.getTriggers(), webHook.getEnabled(), webHook.getWatchedDate(), webHook.getWatchedBy(), webHook.getUpdatedDate(), webHook.getRefreshDate(), webHook.getProjectName(), remoteProject != null ? remoteProject.getIdentifier() : null, remoteProject != null ? remoteProject.getDescription() : null, remoteProject != null ? remoteProject.getAvatarUrl() : null, remoteProject != null ? remoteProject.getLanguages() : null, false, remoteProject != null);
    }

    public static List<WebHookRestEntity> toRestEntities(CrowdinConsumerStorage crowdinConsumerStorage, Collection<WebHook> webHooks, boolean includeLanguages) {
        return webHooks.stream().map(webHook -> WebHookBuilder.toRestEntity(crowdinConsumerStorage, webHook, includeLanguages)).toList();
    }
}

