/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MapResourceBundle
extends ResourceBundle
implements Serializable {
    private static final long serialVersionUID = -7020823660841958748L;
    private static final Pattern PATTERN = Pattern.compile("#\\{.*\\}");
    private Map<String, String> props;
    private Locale locale;

    public MapResourceBundle(Locale l) {
        this.locale = l;
        this.props = new HashMap<String, String>();
    }

    public MapResourceBundle(ResourceBundle rB, Locale l) {
        HashMap<String, String> props = new HashMap<String, String>();
        MapResourceBundle.doMerge(props, rB);
        this.locale = l;
        this.props = props;
    }

    private static void doMerge(Map<String, String> props, ResourceBundle rB) {
        Enumeration<String> e = rB.getKeys();
        while (e.hasMoreElements()) {
            Object o;
            String key = e.nextElement();
            if (props.get(key) != null || !((o = rB.getObject(key)) instanceof String)) continue;
            String value = (String)o;
            props.put(key.intern(), value.intern());
        }
    }

    @Override
    protected Object handleGetObject(String key) {
        return this.props.get(key);
    }

    @Override
    public Enumeration<String> getKeys() {
        final Iterator<String> i = this.props.keySet().iterator();
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return i.hasNext();
            }

            @Override
            public String nextElement() {
                return (String)i.next();
            }
        };
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public void add(String key, Object o) {
        if (key != null && o instanceof String) {
            String value = (String)o;
            this.props.put(key.intern(), value.intern());
        }
    }

    public void remove(String key) {
        if (key != null) {
            this.props.remove(key);
        }
    }

    public void merge(ResourceBundle bundle) {
        MapResourceBundle.doMerge(this.props, bundle);
    }

    public void resolveDependencies() {
        HashMap<String, String> tempMap = new HashMap<String, String>(this.props);
        for (String element : this.props.keySet()) {
            String value = this.lookupKey(tempMap, element, new HashSet<String>());
            if (value == null) continue;
            tempMap.put(element.intern(), value.intern());
        }
        this.props = tempMap;
    }

    private String lookupKey(Map<String, String> props, String key, Set<String> callStack) {
        String s = props.get(key);
        if (s == null || callStack.contains(key)) {
            return key;
        }
        callStack.add(key);
        Matcher matcher = PATTERN.matcher(s);
        if (matcher.find()) {
            return this.recursivedResolving(props, s, callStack);
        }
        callStack.remove(key);
        return s;
    }

    private String recursivedResolving(Map props, String value, Set<String> callStack) {
        String resolved = value;
        StringBuilder sB = new StringBuilder();
        while (resolved.indexOf("#{") != -1) {
            sB.setLength(0);
            int firstIndex = resolved.indexOf(35);
            int lastIndex = resolved.indexOf(125, firstIndex);
            String realKey = resolved.substring(firstIndex + 2, lastIndex);
            sB.append(resolved.substring(0, firstIndex));
            sB.append(this.lookupKey(props, realKey, callStack));
            sB.append(resolved.substring(lastIndex + 1));
            resolved = sB.toString();
        }
        return resolved;
    }
}

