/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.impl;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.util.Date;
import java.util.Objects;
import org.exoplatform.services.organization.ExtendedCloneable;
import org.exoplatform.services.organization.User;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="EXO_USER")
public class UserImpl
implements User,
ExtendedCloneable {
    private static final long serialVersionUID = 6919266039776618161L;
    @Id
    private String id;
    @Column
    private String userName;
    @Column
    private String password;
    @Column
    private String firstName;
    @Column
    private String lastName;
    @Column
    private String email;
    @Column
    private Date createdDate;
    @Column
    private Date lastLoginTime;
    @Column
    private String organizationId;
    @Column
    private String displayName;
    @Column
    private Boolean enabled;
    @Column(name="store")
    private String originatingStore;

    public UserImpl() {
    }

    public UserImpl(String username) {
        this.userName = username;
    }

    @Override
    public String getDisplayName() {
        return this.displayName != null ? this.displayName : this.getFirstName() + " " + this.getLastName();
    }

    @Override
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public void setUserName(String name) {
        this.userName = name;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public String getFullName() {
        return this.getDisplayName();
    }

    @Override
    public void setFullName(String fullName) {
        this.setDisplayName(fullName);
    }

    @Override
    public Date getCreatedDate() {
        return this.createdDate;
    }

    @Override
    public void setCreatedDate(Date t) {
        this.createdDate = t;
    }

    @Override
    public Date getLastLoginTime() {
        return this.lastLoginTime;
    }

    @Override
    public void setLastLoginTime(Date t) {
        this.lastLoginTime = t;
    }

    public String toString() {
        return "User[" + this.id + "|" + this.userName + "]" + (String)(this.organizationId == null ? "" : "@" + this.organizationId);
    }

    @Override
    public String getOrganizationId() {
        return this.organizationId;
    }

    @Override
    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled == null || this.enabled != false;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void setOriginatingStore(String originatingStore) {
        this.originatingStore = originatingStore;
    }

    @Override
    public String getOriginatingStore() {
        return this.originatingStore;
    }

    @Override
    public boolean isInternalStore() {
        return this.originatingStore == null || "internal".equals(this.originatingStore);
    }

    @Override
    public UserImpl clone() {
        UserImpl ui;
        try {
            ui = (UserImpl)super.clone();
            if (this.createdDate != null) {
                ui.createdDate = (Date)this.createdDate.clone();
            }
            if (this.lastLoginTime != null) {
                ui.lastLoginTime = (Date)this.lastLoginTime.clone();
            }
        }
        catch (CloneNotSupportedException e) {
            return this;
        }
        return ui;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserImpl user = (UserImpl)o;
        return Objects.equals(this.id, user.id) && Objects.equals(this.userName, user.userName) && Objects.equals(this.password, user.password) && Objects.equals(this.firstName, user.firstName) && Objects.equals(this.lastName, user.lastName) && Objects.equals(this.email, user.email) && Objects.equals(this.createdDate, user.createdDate) && Objects.equals(this.lastLoginTime, user.lastLoginTime) && Objects.equals(this.organizationId, user.organizationId) && Objects.equals(this.displayName, user.displayName) && Objects.equals(this.enabled, user.enabled);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.userName, this.password, this.firstName, this.lastName, this.email, this.createdDate, this.lastLoginTime, this.organizationId, this.displayName, this.enabled);
    }
}

