/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.plugin;

import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.service.RuleService;
import io.meeds.social.translation.plugin.TranslationPlugin;
import io.meeds.social.translation.service.TranslationService;
import jakarta.annotation.PostConstruct;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RuleTranslationPlugin
extends TranslationPlugin {
    public static final String RULE_OBJECT_TYPE = "rule";
    public static final String RULE_DESCRIPTION_FIELD_NAME = "description";
    public static final String RULE_TITLE_FIELD_NAME = "title";
    @Autowired
    private RuleService ruleService;
    @Autowired
    private SpaceService spaceService;
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private UserACL userACL;
    @Autowired
    private PortalContainer container;

    @PostConstruct
    public void init() {
        ((TranslationService)this.container.getComponentInstanceOfType(TranslationService.class)).addPlugin((TranslationPlugin)this);
    }

    public String getObjectType() {
        return RULE_OBJECT_TYPE;
    }

    public boolean hasAccessPermission(String ruleId, String username) throws ObjectNotFoundException {
        return this.userACL.hasAccessPermission(RULE_OBJECT_TYPE, ruleId, username);
    }

    public boolean hasEditPermission(String ruleId, String username) throws ObjectNotFoundException {
        return this.userACL.hasEditPermission(RULE_OBJECT_TYPE, ruleId, username);
    }

    public long getAudienceId(String ruleId) throws ObjectNotFoundException {
        long spaceId = this.getSpaceId(ruleId);
        if (spaceId == 0L) {
            return 0L;
        }
        Space space = this.spaceService.getSpaceById(String.valueOf(spaceId));
        if (space == null) {
            throw new ObjectNotFoundException(String.format("Space with id %s wasn't found", spaceId));
        }
        Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName());
        return Long.parseLong(spaceIdentity.getId());
    }

    public long getSpaceId(String ruleId) throws ObjectNotFoundException {
        RuleDTO rule = this.ruleService.findRuleById(Long.parseLong(ruleId));
        if (rule == null) {
            throw new ObjectNotFoundException(String.format("Rule with id %s wasn't found", ruleId));
        }
        return rule.getProgram().getSpaceId();
    }
}

