/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.dao;

import io.meeds.gamification.constant.EntityFilterType;
import io.meeds.gamification.constant.EntityStatusType;
import io.meeds.gamification.constant.EntityType;
import io.meeds.gamification.constant.EntityVisibility;
import io.meeds.gamification.entity.ProgramEntity;
import io.meeds.gamification.model.filter.ProgramFilter;
import jakarta.persistence.NoResultException;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.persistence.GenericDAO;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;

public class ProgramDAO
extends GenericDAOJPAImpl<ProgramEntity, Long>
implements GenericDAO<ProgramEntity, Long> {
    private static final String QUERY_FILTER_FIND_PREFIX = "GamificationDomain.findDomains";
    private static final String QUERY_FILTER_COUNT_PREFIX = "GamificationDomain.countDomains";
    public static final String DOMAIN_TITLE = "domainTitle";
    private final Map<String, Boolean> filterNamedQueries = new ConcurrentHashMap<String, Boolean>();

    public ProgramEntity findByIdWithOwners(Long id) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationDomain.findByIdWithOwners", ProgramEntity.class);
        query.setParameter("id", (Object)id);
        try {
            return (ProgramEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public ProgramEntity getProgramByTitle(String domainTitle) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationDomain.findDomainByTitle", ProgramEntity.class);
        query.setParameter(DOMAIN_TITLE, (Object)domainTitle);
        List domainEntities = query.getResultList();
        return !domainEntities.isEmpty() ? (ProgramEntity)domainEntities.get(0) : null;
    }

    public List<Long> getProgramIdsByFilter(int offset, int limit, ProgramFilter filter) {
        TypedQuery<Long> query = this.buildQueryFromFilter(filter, Long.class, false);
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    public int countPrograms(ProgramFilter filter) {
        TypedQuery<Long> query = this.buildQueryFromFilter(filter, Long.class, true);
        return ((Long)query.getSingleResult()).intValue();
    }

    public int countProgramColor(String color) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationDomain.countProgramColor", Long.class);
        query.setParameter("color", (Object)StringUtils.upperCase((String)color));
        try {
            Long result = (Long)query.getSingleResult();
            return result == null ? 0 : result.intValue();
        }
        catch (NoResultException e) {
            return 0;
        }
    }

    private <T> TypedQuery<T> buildQueryFromFilter(ProgramFilter filter, Class<T> clazz, boolean count) {
        TypedQuery query;
        ArrayList<String> suffixes = new ArrayList<String>();
        ArrayList<String> predicates = new ArrayList<String>();
        this.buildPredicates(filter, suffixes, predicates);
        String queryName = this.getQueryFilterName(suffixes, count);
        if (this.filterNamedQueries.containsKey(queryName)) {
            query = this.getEntityManager().createNamedQuery(queryName, clazz);
        } else {
            String queryContent = this.getQueryFilterContent(filter.getSortBy(), filter.isSortDescending(), predicates, count);
            query = this.getEntityManager().createQuery(queryContent, clazz);
            this.getEntityManager().getEntityManagerFactory().addNamedQuery(queryName, (Query)query);
            this.filterNamedQueries.put(queryName, true);
        }
        this.addQueryFilterParameters(filter, query);
        return query;
    }

    private <T> void addQueryFilterParameters(ProgramFilter filter, TypedQuery<T> query) {
        EntityFilterType type;
        if (CollectionUtils.isNotEmpty(filter.getSpacesIds())) {
            query.setParameter("spacesIds", filter.getSpacesIds());
        }
        if (!(filter.getOwnerId() != 0L || filter.isExcludeOpen() || !CollectionUtils.isNotEmpty(filter.getSpacesIds()) && filter.isAllSpaces())) {
            query.setParameter("openVisibility", (Object)EntityVisibility.OPEN);
        }
        if ((type = filter.getType()) != null && type != EntityFilterType.ALL) {
            query.setParameter("type", (Object)EntityType.valueOf(type.name()));
        }
        if (StringUtils.isNotEmpty((CharSequence)filter.getProgramTitle())) {
            query.setParameter("searchingKey", (Object)("%" + filter.getProgramTitle() + "%"));
        }
        if (filter.getOwnerId() > 0L) {
            query.setParameter("ownerId", (Object)filter.getOwnerId());
            if (CollectionUtils.isNotEmpty(filter.getSpacesIds())) {
                query.setParameter("spacesIds", filter.getSpacesIds());
            }
        }
    }

    private void buildPredicates(ProgramFilter filter, List<String> suffixes, List<String> predicates) {
        if (filter.getType() != null && filter.getType() != EntityFilterType.ALL) {
            suffixes.add("Type");
            predicates.add("d.type = :type");
        }
        if (StringUtils.isNotEmpty((CharSequence)filter.getProgramTitle())) {
            suffixes.add("SearchBy");
            predicates.add(" UPPER(d.title) like UPPER(:searchingKey) ");
        }
        if (filter.isIncludeDeleted()) {
            suffixes.add("IncludeDeleted");
        } else {
            predicates.add("d.isDeleted = false");
        }
        EntityStatusType programStatus = filter.getStatus();
        if (programStatus != null && programStatus != EntityStatusType.ALL) {
            switch (programStatus) {
                case ENABLED: {
                    suffixes.add("EnabledStatus");
                    predicates.add("d.isEnabled = true");
                    break;
                }
                case DISABLED: {
                    suffixes.add("DisabledStatus");
                    predicates.add("d.isEnabled = false");
                    break;
                }
            }
        }
        if (filter.getOwnerId() > 0L) {
            if (CollectionUtils.isEmpty(filter.getSpacesIds())) {
                suffixes.add("ByOwnerId");
                predicates.add(":ownerId member of d.owners");
            } else {
                suffixes.add("ByOwnerOrSpaceIds");
                predicates.add("(:ownerId member of d.owners OR d.audienceId in (:spacesIds))");
            }
        } else if (CollectionUtils.isNotEmpty(filter.getSpacesIds())) {
            if (filter.isExcludeOpen()) {
                suffixes.add("AudienceExcludeOpen");
                predicates.add("d.audienceId in (:spacesIds)");
            } else {
                suffixes.add("Audience");
                predicates.add("(d.audienceId IS NULL OR d.visibility = :openVisibility OR d.audienceId in (:spacesIds))");
            }
        } else if (!filter.isAllSpaces()) {
            suffixes.add("OpenAudience");
            predicates.add("(d.audienceId IS NULL OR d.visibility = :openVisibility)");
        }
        if (StringUtils.isNotBlank((CharSequence)filter.getSortBy())) {
            suffixes.add("SortBy");
            suffixes.add(filter.getSortBy());
            if (filter.isSortDescending()) {
                suffixes.add("Descending");
            } else {
                suffixes.add("Ascending");
            }
        }
    }

    private String getQueryFilterName(List<String> suffixes, boolean count) {
        Object queryName = suffixes.isEmpty() ? (count ? QUERY_FILTER_COUNT_PREFIX : QUERY_FILTER_FIND_PREFIX) : (count ? QUERY_FILTER_COUNT_PREFIX : QUERY_FILTER_FIND_PREFIX) + "By" + StringUtils.join(suffixes, (String)"By");
        return queryName;
    }

    private String getQueryFilterContent(String sortField, boolean sortDescending, List<String> predicates, boolean count) {
        String querySelect = count ? "SELECT COUNT(d) FROM GamificationDomain d " : "SELECT d.id FROM GamificationDomain d ";
        Object queryContent = predicates.isEmpty() ? querySelect : querySelect + " WHERE " + StringUtils.join(predicates, (String)" AND ");
        if (!count) {
            queryContent = (String)queryContent + " ORDER BY " + this.getSortFieldName(sortField) + (sortDescending ? " DESC " : " ASC ");
        }
        return queryContent;
    }

    private String getSortFieldName(String sortField) {
        if (StringUtils.isBlank((CharSequence)sortField)) {
            sortField = "title";
        }
        return switch (sortField) {
            case "title" -> "d.title";
            case "id", "createdDate" -> "d.id";
            case "modifiedDate" -> "d.lastModifiedDate";
            case "type" -> "d.type";
            case "recurrence" -> "d.recurrence";
            case "priority" -> "d.priority";
            case "audience" -> "d.audienceId";
            default -> "d.title";
        };
    }
}

