/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.reward.entity;

import io.meeds.wallet.reward.entity.WalletRewardPeriodEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.io.Serializable;
import lombok.Generated;
import org.hibernate.annotations.DynamicUpdate;

@Entity(name="Reward")
@DynamicUpdate
@Table(name="ADDONS_WALLET_REWARD")
public class WalletRewardEntity
implements Serializable {
    private static final long serialVersionUID = 4475704534821391132L;
    @Id
    @SequenceGenerator(name="SEQ_WALLET_REWARD_ID", sequenceName="SEQ_WALLET_REWARD_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_WALLET_REWARD_ID")
    @Column(name="REWARD_ID")
    private Long id;
    @Column(name="IDENTITY_ID", nullable=false)
    private Long identityId;
    @Column(name="TRANSACTION_HASH")
    private String transactionHash;
    @Column(name="ENABLED")
    private boolean enabled;
    @Column(name="TOKENS_SENT")
    private double tokensSent;
    @Column(name="TOKENS_TO_SEND")
    private double tokensToSend;
    @Column(name="POINTS")
    private Double points;
    @ManyToOne(fetch=FetchType.EAGER, optional=false)
    @JoinColumn(name="REWARD_PERIOD_ID", referencedColumnName="REWARD_PERIOD_ID")
    private WalletRewardPeriodEntity period;

    @Generated
    public WalletRewardEntity() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getIdentityId() {
        return this.identityId;
    }

    @Generated
    public String getTransactionHash() {
        return this.transactionHash;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public double getTokensSent() {
        return this.tokensSent;
    }

    @Generated
    public double getTokensToSend() {
        return this.tokensToSend;
    }

    @Generated
    public Double getPoints() {
        return this.points;
    }

    @Generated
    public WalletRewardPeriodEntity getPeriod() {
        return this.period;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setIdentityId(Long identityId) {
        this.identityId = identityId;
    }

    @Generated
    public void setTransactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setTokensSent(double tokensSent) {
        this.tokensSent = tokensSent;
    }

    @Generated
    public void setTokensToSend(double tokensToSend) {
        this.tokensToSend = tokensToSend;
    }

    @Generated
    public void setPoints(Double points) {
        this.points = points;
    }

    @Generated
    public void setPeriod(WalletRewardPeriodEntity period) {
        this.period = period;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WalletRewardEntity)) {
            return false;
        }
        WalletRewardEntity other = (WalletRewardEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (Double.compare(this.getTokensSent(), other.getTokensSent()) != 0) {
            return false;
        }
        if (Double.compare(this.getTokensToSend(), other.getTokensToSend()) != 0) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$identityId = this.getIdentityId();
        Long other$identityId = other.getIdentityId();
        if (this$identityId == null ? other$identityId != null : !((Object)this$identityId).equals(other$identityId)) {
            return false;
        }
        Double this$points = this.getPoints();
        Double other$points = other.getPoints();
        if (this$points == null ? other$points != null : !((Object)this$points).equals(other$points)) {
            return false;
        }
        String this$transactionHash = this.getTransactionHash();
        String other$transactionHash = other.getTransactionHash();
        if (this$transactionHash == null ? other$transactionHash != null : !this$transactionHash.equals(other$transactionHash)) {
            return false;
        }
        WalletRewardPeriodEntity this$period = this.getPeriod();
        WalletRewardPeriodEntity other$period = other.getPeriod();
        return !(this$period == null ? other$period != null : !((Object)this$period).equals(other$period));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WalletRewardEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        long $tokensSent = Double.doubleToLongBits(this.getTokensSent());
        result = result * 59 + (int)($tokensSent >>> 32 ^ $tokensSent);
        long $tokensToSend = Double.doubleToLongBits(this.getTokensToSend());
        result = result * 59 + (int)($tokensToSend >>> 32 ^ $tokensToSend);
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $identityId = this.getIdentityId();
        result = result * 59 + ($identityId == null ? 43 : ((Object)$identityId).hashCode());
        Double $points = this.getPoints();
        result = result * 59 + ($points == null ? 43 : ((Object)$points).hashCode());
        String $transactionHash = this.getTransactionHash();
        result = result * 59 + ($transactionHash == null ? 43 : $transactionHash.hashCode());
        WalletRewardPeriodEntity $period = this.getPeriod();
        result = result * 59 + ($period == null ? 43 : ((Object)$period).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "WalletRewardEntity(id=" + this.getId() + ", identityId=" + this.getIdentityId() + ", transactionHash=" + this.getTransactionHash() + ", enabled=" + this.isEnabled() + ", tokensSent=" + this.getTokensSent() + ", tokensToSend=" + this.getTokensToSend() + ", points=" + this.getPoints() + ", period=" + String.valueOf(this.getPeriod()) + ")";
    }
}

