/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.ens;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.abi.DefaultFunctionReturnDecoder;
import org.web3j.abi.datatypes.ens.OffchainLookup;
import org.web3j.crypto.WalletUtils;
import org.web3j.dto.EnsGatewayRequestDTO;
import org.web3j.dto.EnsGatewayResponseDTO;
import org.web3j.ens.Contracts;
import org.web3j.ens.EnsResolutionException;
import org.web3j.ens.NameHash;
import org.web3j.ens.contracts.generated.ENS;
import org.web3j.ens.contracts.generated.OffchainResolverContract;
import org.web3j.ens.contracts.generated.PublicResolver;
import org.web3j.protocol.ObjectMapperFactory;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.methods.response.EthBlock;
import org.web3j.protocol.core.methods.response.EthSyncing;
import org.web3j.protocol.core.methods.response.NetVersion;
import org.web3j.service.HSMHTTPRequestProcessor;
import org.web3j.tx.ClientTransactionManager;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;
import org.web3j.tx.gas.DefaultGasProvider;
import org.web3j.utils.EnsUtils;
import org.web3j.utils.Numeric;
import org.web3j.utils.Strings;

public class EnsResolver {
    private static final Logger log = LoggerFactory.getLogger(EnsResolver.class);
    public static final long DEFAULT_SYNC_THRESHOLD = 180000L;
    public static final int LOOKUP_LIMIT = 4;
    public static final String REVERSE_NAME_SUFFIX = ".addr.reverse";
    private final Web3j web3j;
    private final int addressLength;
    private final TransactionManager transactionManager;
    private OkHttpClient client = new OkHttpClient();
    private long syncThreshold;

    public EnsResolver(Web3j web3j, long syncThreshold, int addressLength) {
        this.web3j = web3j;
        this.transactionManager = new ClientTransactionManager(web3j, null);
        this.syncThreshold = syncThreshold;
        this.addressLength = addressLength;
    }

    public EnsResolver(Web3j web3j, long syncThreshold) {
        this(web3j, syncThreshold, 40);
    }

    public EnsResolver(Web3j web3j) {
        this(web3j, 180000L);
    }

    public void setSyncThreshold(long syncThreshold) {
        this.syncThreshold = syncThreshold;
    }

    public long getSyncThreshold() {
        return this.syncThreshold;
    }

    @Deprecated
    protected PublicResolver obtainPublicResolver(String ensName) {
        if (EnsResolver.isValidEnsName(ensName, this.addressLength)) {
            try {
                if (!this.isSynced()) {
                    throw new EnsResolutionException("Node is not currently synced");
                }
                return this.lookupResolver(ensName);
            }
            catch (Exception e) {
                throw new EnsResolutionException("Unable to determine sync status of node", e);
            }
        }
        throw new EnsResolutionException("EnsName is invalid: " + ensName);
    }

    protected OffchainResolverContract obtainOffchainResolver(String ensName) {
        if (EnsResolver.isValidEnsName(ensName, this.addressLength)) {
            try {
                if (!this.isSynced()) {
                    throw new EnsResolutionException("Node is not currently synced");
                }
                return this.lookupOffchainResolver(ensName);
            }
            catch (Exception e) {
                throw new EnsResolutionException("Unable to determine sync status of node", e);
            }
        }
        throw new EnsResolutionException("EnsName is invalid: " + ensName);
    }

    public String resolve(String ensName) {
        if (Strings.isBlank((String)ensName) || ensName.trim().length() == 1 && ensName.contains(".")) {
            return null;
        }
        try {
            if (EnsResolver.isValidEnsName(ensName, this.addressLength)) {
                String resolvedName;
                OffchainResolverContract resolver = this.obtainOffchainResolver(ensName);
                boolean supportWildcard = (Boolean)resolver.supportsInterface(EnsUtils.ENSIP_10_INTERFACE_ID).send();
                byte[] nameHash = NameHash.nameHashAsBytes(ensName);
                if (supportWildcard) {
                    String dnsEncoded = NameHash.dnsEncode(ensName);
                    String addrFunction = resolver.addr(nameHash).encodeFunctionCall();
                    String lookupDataHex = (String)resolver.resolve(Numeric.hexStringToByteArray((String)dnsEncoded), Numeric.hexStringToByteArray((String)addrFunction)).send();
                    resolvedName = this.resolveOffchain(lookupDataHex, resolver, 4);
                } else {
                    try {
                        resolvedName = (String)resolver.addr(nameHash).send();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unable to execute Ethereum request: ", e);
                    }
                }
                if (!WalletUtils.isValidAddress(resolvedName)) {
                    throw new EnsResolutionException("Unable to resolve address for name: " + ensName);
                }
                return resolvedName;
            }
            return ensName;
        }
        catch (Exception e) {
            throw new EnsResolutionException(e);
        }
    }

    protected String resolveOffchain(String lookupData, OffchainResolverContract resolver, int lookupCounter) throws Exception {
        if (EnsUtils.isEIP3668(lookupData)) {
            OffchainLookup offchainLookup = OffchainLookup.build((byte[])Numeric.hexStringToByteArray((String)lookupData.substring(10)));
            if (!resolver.getContractAddress().equals(offchainLookup.getSender())) {
                throw new EnsResolutionException("Cannot handle OffchainLookup raised inside nested call");
            }
            String gatewayResult = this.ccipReadFetch(offchainLookup.getUrls(), offchainLookup.getSender(), Numeric.toHexString((byte[])offchainLookup.getCallData()));
            if (gatewayResult == null) {
                throw new EnsResolutionException("CCIP Read disabled or provided no URLs.");
            }
            ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();
            EnsGatewayResponseDTO gatewayResponseDTO = (EnsGatewayResponseDTO)objectMapper.readValue(gatewayResult, EnsGatewayResponseDTO.class);
            String resolvedNameHex = (String)resolver.resolveWithProof(Numeric.hexStringToByteArray((String)gatewayResponseDTO.getData()), offchainLookup.getExtraData()).send();
            if (EnsUtils.isEIP3668(resolvedNameHex)) {
                if (lookupCounter <= 0) {
                    throw new EnsResolutionException("Lookup calls is out of limit.");
                }
                return this.resolveOffchain(lookupData, resolver, --lookupCounter);
            }
            byte[] resolvedNameBytes = DefaultFunctionReturnDecoder.decodeDynamicBytes((String)resolvedNameHex);
            return DefaultFunctionReturnDecoder.decodeAddress((String)Numeric.toHexString((byte[])resolvedNameBytes));
        }
        return lookupData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String ccipReadFetch(List<String> urls, String sender, String data) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        for (String url : urls) {
            Request request;
            try {
                request = this.buildRequest(url, sender, data);
            }
            catch (JsonProcessingException | EnsResolutionException e) {
                log.error(e.getMessage(), e);
                break;
            }
            try {
                Response response = this.client.newCall(request).execute();
                Throwable throwable = null;
                try {
                    if (response.isSuccessful()) {
                        ResponseBody responseBody = response.body();
                        if (responseBody != null) {
                            String string = new BufferedReader(new InputStreamReader(responseBody.byteStream())).lines().collect(Collectors.joining("\n"));
                            return string;
                        }
                        log.warn("Response body is null, url: {}", (Object)url);
                        break;
                    }
                    int statusCode = response.code();
                    if (statusCode >= 400 && statusCode < 500) {
                        log.error("Response error during CCIP fetch: url {}, error: {}", (Object)url, (Object)response.message());
                        throw new EnsResolutionException(response.message());
                    }
                    errorMessages.add(response.message());
                    log.warn("Response error 500 during CCIP fetch: url {}, error: {}", (Object)url, (Object)response.message());
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (response == null) continue;
                    if (throwable != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    response.close();
                }
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        log.warn(Arrays.toString(errorMessages.toArray()));
        return null;
    }

    protected Request buildRequest(String url, String sender, String data) throws JsonProcessingException {
        if (sender == null || !WalletUtils.isValidAddress(sender)) {
            throw new EnsResolutionException("Sender address is null or not valid");
        }
        if (data == null) {
            throw new EnsResolutionException("Data is null");
        }
        if (!url.contains("{sender}")) {
            throw new EnsResolutionException("Url is not valid, sender parameter is not exist");
        }
        String href = url.replace("{sender}", sender).replace("{data}", data);
        Request.Builder builder = new Request.Builder().url(href);
        if (url.contains("{data}")) {
            return builder.get().build();
        }
        EnsGatewayRequestDTO requestDTO = new EnsGatewayRequestDTO(data);
        ObjectMapper om = ObjectMapperFactory.getObjectMapper();
        return builder.post(RequestBody.create((String)om.writeValueAsString((Object)requestDTO), (MediaType)HSMHTTPRequestProcessor.JSON)).addHeader("Content-Type", "application/json").build();
    }

    public String reverseResolve(String address) {
        if (WalletUtils.isValidAddress(address, this.addressLength)) {
            String name;
            String reverseName = Numeric.cleanHexPrefix((String)address) + REVERSE_NAME_SUFFIX;
            OffchainResolverContract resolver = this.obtainOffchainResolver(reverseName);
            byte[] nameHash = NameHash.nameHashAsBytes(reverseName);
            try {
                name = (String)resolver.name(nameHash).send();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to execute Ethereum request", e);
            }
            if (!EnsResolver.isValidEnsName(name, this.addressLength)) {
                throw new RuntimeException("Unable to resolve name for address: " + address);
            }
            return name;
        }
        throw new EnsResolutionException("Address is invalid: " + address);
    }

    private PublicResolver lookupResolver(String ensName) throws Exception {
        return PublicResolver.load(this.getResolverAddress(ensName), this.web3j, this.transactionManager, (ContractGasProvider)new DefaultGasProvider());
    }

    private OffchainResolverContract lookupOffchainResolver(String ensName) throws Exception {
        return OffchainResolverContract.load(this.getResolverAddress(ensName), this.web3j, this.transactionManager, (ContractGasProvider)new DefaultGasProvider());
    }

    private String getResolverAddress(String ensName) throws Exception {
        byte[] nameHash;
        NetVersion netVersion = this.web3j.netVersion().send();
        String registryContract = Contracts.resolveRegistryContract(netVersion.getNetVersion());
        ENS ensRegistry = ENS.load(registryContract, this.web3j, this.transactionManager, (ContractGasProvider)new DefaultGasProvider());
        String address = (String)ensRegistry.resolver(nameHash = NameHash.nameHashAsBytes(ensName)).send();
        if (EnsUtils.isAddressEmpty(address)) {
            address = this.getResolverAddress(EnsUtils.getParent(ensName));
        }
        return address;
    }

    boolean isSynced() throws Exception {
        EthSyncing ethSyncing = this.web3j.ethSyncing().send();
        if (ethSyncing.isSyncing()) {
            return false;
        }
        EthBlock ethBlock = this.web3j.ethGetBlockByNumber(DefaultBlockParameterName.LATEST, false).send();
        long timestamp = ethBlock.getBlock().getTimestamp().longValue() * 1000L;
        return System.currentTimeMillis() - this.syncThreshold < timestamp;
    }

    public static boolean isValidEnsName(String input) {
        return EnsResolver.isValidEnsName(input, 40);
    }

    public static boolean isValidEnsName(String input, int addressLength) {
        return input != null && (input.contains(".") || !WalletUtils.isValidAddress(input, addressLength));
    }

    public void setHttpClient(OkHttpClient client) {
        this.client = client;
    }
}

