/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.twitter.gamification.rest;

import io.meeds.twitter.gamification.model.TokenStatus;
import io.meeds.twitter.gamification.service.TwitterConsumerService;
import io.meeds.twitter.gamification.service.TwitterService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"settings"})
@Tag(name="twitter/settings", description="Manage and access twitter settings")
public class TwitterSettingsRest {
    @Autowired
    private TwitterService twitterService;
    @Autowired
    private TwitterConsumerService twitterConsumerService;

    @PostMapping
    @Secured(value={"rewarding"})
    @Operation(summary="Saves a Twitter bearer token.", description="Saves a Twitter bearer token.", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public void saveBearerToken(HttpServletRequest request, @Parameter(description="Twitter bearer token", required=true) @RequestParam(value="bearerToken") String bearerToken) {
        if (StringUtils.isBlank((CharSequence)bearerToken)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "'bearerToken' parameter is mandatory");
        }
        try {
            this.twitterService.saveTwitterBearerToken(bearerToken, request.getRemoteUser());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, e.getMessage());
        }
    }

    @DeleteMapping
    @Secured(value={"rewarding"})
    @Operation(summary="Deletes Twitter bearer token.", description="Deletes Twitter bearer token.", method="DELETE")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public void deleteTwitterBearerToken(HttpServletRequest request) {
        try {
            this.twitterService.deleteTwitterBearerToken(request.getRemoteUser());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, e.getMessage());
        }
    }

    @GetMapping
    @Secured(value={"rewarding"})
    @Operation(summary="Checks if a twitter bearer token is stored", description="This returns if twitter bearer token is stored or not", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="404", description="Resource not found"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public TokenStatus checkTwitterTokenStatus(HttpServletRequest request) {
        try {
            String bearerToken = this.twitterService.getTwitterBearerToken(request.getRemoteUser());
            return this.twitterConsumerService.checkTwitterTokenStatus(bearerToken);
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, e.getMessage());
        }
    }
}

