/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.slm;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class SnapshotPolicyStats
implements JsonpSerializable {
    private final String policy;
    private final long snapshotsTaken;
    private final long snapshotsFailed;
    private final long snapshotsDeleted;
    private final long snapshotDeletionFailures;
    public static final JsonpDeserializer<SnapshotPolicyStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SnapshotPolicyStats::setupSnapshotPolicyStatsDeserializer);

    private SnapshotPolicyStats(Builder builder) {
        this.policy = ApiTypeHelper.requireNonNull(builder.policy, this, "policy");
        this.snapshotsTaken = ApiTypeHelper.requireNonNull(builder.snapshotsTaken, (Object)this, "snapshotsTaken", 0L);
        this.snapshotsFailed = ApiTypeHelper.requireNonNull(builder.snapshotsFailed, (Object)this, "snapshotsFailed", 0L);
        this.snapshotsDeleted = ApiTypeHelper.requireNonNull(builder.snapshotsDeleted, (Object)this, "snapshotsDeleted", 0L);
        this.snapshotDeletionFailures = ApiTypeHelper.requireNonNull(builder.snapshotDeletionFailures, (Object)this, "snapshotDeletionFailures", 0L);
    }

    public static SnapshotPolicyStats of(Function<Builder, ObjectBuilder<SnapshotPolicyStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String policy() {
        return this.policy;
    }

    public final long snapshotsTaken() {
        return this.snapshotsTaken;
    }

    public final long snapshotsFailed() {
        return this.snapshotsFailed;
    }

    public final long snapshotsDeleted() {
        return this.snapshotsDeleted;
    }

    public final long snapshotDeletionFailures() {
        return this.snapshotDeletionFailures;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("policy");
        generator.write(this.policy);
        generator.writeKey("snapshots_taken");
        generator.write(this.snapshotsTaken);
        generator.writeKey("snapshots_failed");
        generator.write(this.snapshotsFailed);
        generator.writeKey("snapshots_deleted");
        generator.write(this.snapshotsDeleted);
        generator.writeKey("snapshot_deletion_failures");
        generator.write(this.snapshotDeletionFailures);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupSnapshotPolicyStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::policy, JsonpDeserializer.stringDeserializer(), "policy");
        op.add(Builder::snapshotsTaken, JsonpDeserializer.longDeserializer(), "snapshots_taken");
        op.add(Builder::snapshotsFailed, JsonpDeserializer.longDeserializer(), "snapshots_failed");
        op.add(Builder::snapshotsDeleted, JsonpDeserializer.longDeserializer(), "snapshots_deleted");
        op.add(Builder::snapshotDeletionFailures, JsonpDeserializer.longDeserializer(), "snapshot_deletion_failures");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SnapshotPolicyStats> {
        private String policy;
        private Long snapshotsTaken;
        private Long snapshotsFailed;
        private Long snapshotsDeleted;
        private Long snapshotDeletionFailures;

        public final Builder policy(String value) {
            this.policy = value;
            return this;
        }

        public final Builder snapshotsTaken(long value) {
            this.snapshotsTaken = value;
            return this;
        }

        public final Builder snapshotsFailed(long value) {
            this.snapshotsFailed = value;
            return this;
        }

        public final Builder snapshotsDeleted(long value) {
            this.snapshotsDeleted = value;
            return this;
        }

        public final Builder snapshotDeletionFailures(long value) {
            this.snapshotDeletionFailures = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SnapshotPolicyStats build() {
            this._checkSingleUse();
            return new SnapshotPolicyStats(this);
        }
    }
}

