/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.storage.search;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.search.domain.Document;
import org.exoplatform.commons.search.index.impl.ElasticIndexingServiceConnector;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.search.DocumentWithMetadata;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.service.TaskService;
import org.jsoup.Jsoup;

public class TaskIndexingServiceConnector
extends ElasticIndexingServiceConnector {
    public static final String TYPE = "task";
    private static final Log LOG = ExoLogger.getLogger(TaskIndexingServiceConnector.class);
    private final TaskService taskService;

    public TaskIndexingServiceConnector(InitParams initParams, TaskService taskService) {
        super(initParams);
        this.taskService = taskService;
    }

    public String getConnectorName() {
        return TYPE;
    }

    public Document create(String s) {
        return this.getDocument(s);
    }

    public Document update(String s) {
        return this.getDocument(s);
    }

    public List<String> getAllIds(int offset, int limit) {
        return this.taskService.getAllIds(offset, limit).stream().map(Object::toString).toList();
    }

    public String getMapping() {
        return "{\n  \"properties\": {\n    \"id\": {\"type\": \"keyword\"},\n    \"title\": {\n      \"type\": \"text\",\n      \"analyzer\": \"ngram_analyzer\",\n      \"search_analyzer\": \"ngram_analyzer_search\",\n      \"index_options\": \"offsets\",\n      \"fields\": {\n        \"raw\": {\"type\": \"keyword\"}\n      }\n    },\n    \"description\": {\n      \"type\": \"text\",\n      \"analyzer\": \"ngram_analyzer\",\n      \"search_analyzer\": \"ngram_analyzer_search\",\n      \"index_options\": \"offsets\",\n      \"fields\": {\n        \"raw\": {\"type\": \"keyword\"}\n      }\n    },\n    \"status\": {\"type\": \"keyword\"},\n    \"priority\": {\"type\": \"keyword\"},\n    \"project\": {\"type\": \"keyword\"},\n    \"creator\": {\"type\": \"keyword\"},\n    \"lastUpdatedDate\": {\"type\": \"date\", \"format\": \"epoch_millis\"},\n    \"permissions\": {\"type\": \"keyword\"}\n  }\n}\n";
    }

    private Document getDocument(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("id is mandatory");
        }
        LOG.debug("Index document for task with id={}", new Object[]{id});
        Long taskId = Long.valueOf(id);
        TaskDto task = this.taskService.getTask(taskId);
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("id", Long.toString(taskId));
        fields.put("title", task.getTitle());
        fields.put("description", this.htmlToText(task.getDescription()));
        DocumentWithMetadata doc = new DocumentWithMetadata();
        doc.setFields(fields);
        doc.setId(String.valueOf(taskId));
        doc.setLastUpdatedDate(new Date());
        HashSet<String> permissions = new HashSet<String>();
        permissions.add(task.getCreatedBy());
        if (task.getAssignee() != null) {
            permissions.add(task.getAssignee());
        }
        if (task.getCoworker() != null) {
            permissions.addAll(task.getCoworker());
        }
        if (task.getStatus() != null && task.getStatus().getProject() != null) {
            fields.put("projectId", String.valueOf(task.getStatus().getProject().getId()));
            fields.put("statusId", String.valueOf(task.getStatus().getId()));
            permissions.addAll(task.getStatus().getProject().getParticipator());
            permissions.addAll(task.getStatus().getProject().getManager());
        }
        doc.setPermissions(permissions);
        return doc;
    }

    private String htmlToText(String source) {
        return source == null ? "" : Jsoup.parse((String)source).text();
    }
}

