/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.storage.cached;

import io.meeds.wallet.dao.WalletTransactionDAO;
import io.meeds.wallet.model.TransactionDetail;
import io.meeds.wallet.storage.TransactionStorage;
import java.io.Serializable;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.listener.ListenerService;

public class CachedTransactionStorage
extends TransactionStorage {
    private FutureExoCache<String, TransactionDetail, Object> transactionFutureCache = null;

    public CachedTransactionStorage(CacheService cacheService, ListenerService listenerService, WalletTransactionDAO walletTransactionDAO) {
        super(listenerService, walletTransactionDAO);
        ExoCache transactionCache = cacheService.getCacheInstance("wallet.transaction");
        this.transactionFutureCache = new FutureExoCache((Loader)new Loader<String, TransactionDetail, Object>(){

            public TransactionDetail retrieve(Object context, String hash) throws Exception {
                return CachedTransactionStorage.super.getTransactionByHash(hash);
            }
        }, transactionCache);
    }

    @Override
    public TransactionDetail getTransactionByHash(String hash) {
        TransactionDetail transactionDetail = (TransactionDetail)this.transactionFutureCache.get(null, (Object)hash.toLowerCase());
        return transactionDetail == null ? null : transactionDetail.clone();
    }

    @Override
    public void saveTransactionDetail(TransactionDetail transactionDetail) {
        super.saveTransactionDetail(transactionDetail);
        this.transactionFutureCache.remove((Serializable)((Object)transactionDetail.getHash().toLowerCase()));
    }

    public void clearCache() {
        this.transactionFutureCache.clear();
    }
}

