/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.url.simple;

import java.util.HashSet;
import java.util.Set;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.url.PortalURL;
import org.exoplatform.web.url.ResourceType;
import org.exoplatform.web.url.URLContext;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;

public class SimpleURL
extends PortalURL<NavigationResource, SimpleURL> {
    public static final ResourceType<NavigationResource, SimpleURL> TYPE = new ResourceType<NavigationResource, SimpleURL>(){};
    public static final QualifiedName LANG = QualifiedName.create("gtn", "lang");
    private static final Set<QualifiedName> PARAMETER_NAMES = new HashSet<QualifiedName>();
    private NavigationResource resource;

    public SimpleURL(URLContext context) throws NullPointerException {
        super(context);
    }

    @Override
    public NavigationResource getResource() {
        return this.resource;
    }

    @Override
    public SimpleURL setResource(NavigationResource resource) {
        this.resource = resource;
        return this;
    }

    @Override
    public Set<QualifiedName> getParameterNames() {
        return PARAMETER_NAMES;
    }

    @Override
    public String getParameterValue(QualifiedName parameterName) {
        if (NodeURL.PATH.equals(parameterName)) {
            if (this.resource.getNodeURI() == null) {
                return "";
            }
            return this.resource.getNodeURI();
        }
        if (NodeURL.REQUEST_SITE_TYPE.equals(parameterName)) {
            return this.resource.getSiteType().getName();
        }
        if (NodeURL.REQUEST_SITE_NAME.equals(parameterName)) {
            return this.resource.getSiteName();
        }
        return null;
    }

    static {
        PARAMETER_NAMES.add(NodeURL.PATH);
        PARAMETER_NAMES.add(NodeURL.REQUEST_SITE_TYPE);
        PARAMETER_NAMES.add(NodeURL.REQUEST_SITE_NAME);
        PARAMETER_NAMES.add(LANG);
    }
}

