/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.space.plugin;

import io.meeds.social.cms.model.ContentLinkExtension;
import io.meeds.social.cms.model.ContentLinkSearchResult;
import io.meeds.social.cms.plugin.ContentLinkPlugin;
import io.meeds.social.cms.service.ContentLinkPluginService;
import jakarta.annotation.PostConstruct;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SpaceContentLinkPlugin
implements ContentLinkPlugin {
    public static final String OBJECT_TYPE = "space";
    private static final String TITLE_KEY = "contentLink.space";
    private static final String ICON = "fa fa-users";
    private static final String COMMAND = "space";
    private static final ContentLinkExtension EXTENSION = new ContentLinkExtension("space", "contentLink.space", "fa fa-users", "space", true);
    @Autowired
    private SpaceService spaceService;
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private PortalContainer container;

    @PostConstruct
    public void init() {
        ((ContentLinkPluginService)this.container.getComponentInstanceOfType(ContentLinkPluginService.class)).addPlugin((ContentLinkPlugin)this);
    }

    public ContentLinkExtension getExtension() {
        return EXTENSION;
    }

    public List<ContentLinkSearchResult> search(String keyword, Identity identity, Locale locale, int offset, int limit) {
        ListAccess memberSpacesListAccess;
        Object[] spaces;
        String username;
        SpaceFilter spaceFilter = new SpaceFilter();
        spaceFilter.setSpaceNameSearchCondition(StringUtils.trim((String)keyword));
        String string = username = identity == null ? null : identity.getUserId();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            spaceFilter.setIdentityId(this.identityManager.getOrCreateUserIdentity(identity.getUserId()).getIdentityId());
        }
        if (ArrayUtils.isEmpty((Object[])(spaces = (Space[])(memberSpacesListAccess = this.spaceService.getMemberSpacesByFilter(username, spaceFilter)).load(offset, limit)))) {
            return Collections.emptyList();
        }
        return Stream.of(spaces).map(this::toContentLink).toList();
    }

    public String getContentTitle(String objectId, Locale locale) {
        Space space = this.spaceService.getSpaceById(objectId);
        return space == null ? "" : space.getDisplayName();
    }

    private ContentLinkSearchResult toContentLink(Space space) {
        return new ContentLinkSearchResult("space", String.valueOf(space.getId()), space.getDisplayName(), EXTENSION.getIcon(), EXTENSION.isDrawer());
    }
}

