/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.space.template.storage;

import io.meeds.social.space.template.dao.SpaceTemplateDAO;
import io.meeds.social.space.template.entity.SpaceTemplateEntity;
import io.meeds.social.space.template.model.SpaceTemplate;
import io.meeds.social.space.template.utils.EntityMapper;
import java.util.List;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class SpaceTemplateStorage {
    private SpaceTemplateDAO spaceTemplateDAO;

    public SpaceTemplateStorage(SpaceTemplateDAO spaceTemplateDAO) {
        this.spaceTemplateDAO = spaceTemplateDAO;
    }

    @Cacheable(cacheNames={"social.spaceTemplates"})
    public List<SpaceTemplate> getSpaceTemplates(Pageable pageable) {
        return this.spaceTemplateDAO.findByDeletedFalse(pageable).stream().map(EntityMapper::fromEntity).toList();
    }

    @Cacheable(cacheNames={"social.enabledSpaceTemplates"})
    public List<SpaceTemplate> getEnabledSpaceTemplates(Pageable pageable) {
        return this.spaceTemplateDAO.findByDeletedFalseAndEnabledTrue(pageable).stream().map(EntityMapper::fromEntity).toList();
    }

    @Cacheable(cacheNames={"social.spaceTemplates"})
    public SpaceTemplate getSpaceTemplate(long id) {
        return this.spaceTemplateDAO.findById(id).map(EntityMapper::fromEntity).orElse(null);
    }

    @Cacheable(cacheNames={"social.spaceTemplates"})
    public SpaceTemplate getSpaceTemplateByLayout(String layout) {
        return this.spaceTemplateDAO.findByLayout(layout).map(EntityMapper::fromEntity).orElse(null);
    }

    @CacheEvict(cacheNames={"social.spaceTemplates", "social.enabledSpaceTemplates"}, allEntries=true)
    public SpaceTemplate createSpaceTemplate(SpaceTemplate spaceTemplate) {
        SpaceTemplateEntity spaceTemplateEntity = EntityMapper.toEntity(spaceTemplate);
        spaceTemplateEntity = (SpaceTemplateEntity)this.spaceTemplateDAO.save(spaceTemplateEntity);
        return EntityMapper.fromEntity(spaceTemplateEntity);
    }

    @CacheEvict(cacheNames={"social.spaceTemplates", "social.enabledSpaceTemplates"}, allEntries=true)
    public SpaceTemplate updateSpaceTemplate(SpaceTemplate spaceTemplate) throws ObjectNotFoundException {
        if (!this.spaceTemplateDAO.existsById(spaceTemplate.getId())) {
            throw new ObjectNotFoundException("Space template doesn't exist");
        }
        SpaceTemplateEntity spaceTemplateEntity = EntityMapper.toEntity(spaceTemplate);
        spaceTemplateEntity = (SpaceTemplateEntity)this.spaceTemplateDAO.save(spaceTemplateEntity);
        return EntityMapper.fromEntity(spaceTemplateEntity);
    }

    @CacheEvict(cacheNames={"social.spaceTemplates", "social.enabledSpaceTemplates"}, allEntries=true)
    public void deleteSpaceTemplate(long id) {
        this.spaceTemplateDAO.deleteById(id);
    }
}

