/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.listeners;

import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class SpaceInvitationUserEventListener
extends UserEventListener {
    private static final Log LOG = ExoLogger.getLogger(SpaceInvitationUserEventListener.class);
    private ExoContainer container;
    private SpaceService spaceService;
    private OrganizationService organizationService;

    public SpaceInvitationUserEventListener(ExoContainer container) {
        this.container = container;
    }

    public void postSave(User user, boolean isNew) throws Exception {
        if (!isNew) {
            return;
        }
        List spacesToJoin = this.getSpaceService().findExternalInvitationsSpacesByEmail(user.getEmail());
        if (CollectionUtils.isNotEmpty((Collection)spacesToJoin)) {
            for (String spaceId : spacesToJoin) {
                this.addUserToSpace(user, spaceId, 5);
            }
            this.spaceService.deleteExternalUserInvitations(user.getEmail());
        }
        RequestLifeCycle.restartTransaction();
    }

    public void addUserToSpace(User user, String spaceId, int tentative) {
        String username = user.getUserName();
        Space space = this.spaceService.getSpaceById(spaceId);
        this.spaceService.addMember(space, username);
        Collection memberships = this.getOrganizationService().getMembershipHandler().findMembershipsByUser(username);
        if (memberships.stream().noneMatch(m -> m.getGroupId().equals(space.getGroupId()))) {
            if (tentative > 1) {
                LOG.warn("User invitation '{}' to space '{}({})' seems not considered, attempt adding user to space again", new Object[]{username, space.getDisplayName(), space.getId()});
                this.spaceService.removeMember(space, username);
                RequestLifeCycle.restartTransaction();
                this.addUserToSpace(user, spaceId, tentative - 1);
            } else {
                LOG.warn("User invitation '{}' to space '{}({})' seems not considered. Ignore adding User to space.", new Object[]{username, space.getDisplayName(), space.getId()});
            }
        } else {
            LOG.info("Invited user '{}' to space '{}({})' added as member", new Object[]{username, space.getDisplayName(), space.getId()});
        }
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.container.getComponentInstanceOfType(SpaceService.class);
        }
        return this.spaceService;
    }

    public OrganizationService getOrganizationService() {
        if (this.organizationService == null) {
            this.organizationService = (OrganizationService)this.container.getComponentInstanceOfType(OrganizationService.class);
        }
        return this.organizationService;
    }
}

