/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.provider;

import jakarta.persistence.EntityManager;
import jakarta.persistence.metamodel.Metamodel;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

abstract class JpaClassUtils {
    private JpaClassUtils() {
    }

    public static boolean isEntityManagerOfType(EntityManager em, String type) {
        EntityManager delegate;
        Object object = em.getDelegate();
        EntityManager entityManagerToUse = object instanceof EntityManager ? (delegate = (EntityManager)object) : em;
        return JpaClassUtils.isOfType(entityManagerToUse, type, entityManagerToUse.getClass().getClassLoader());
    }

    public static boolean isMetamodelOfType(Metamodel metamodel, String type) {
        return JpaClassUtils.isOfType(metamodel, type, metamodel.getClass().getClassLoader());
    }

    static boolean isOfType(Object source, String typeName, @Nullable ClassLoader classLoader) {
        Assert.notNull((Object)source, (String)"Source instance must not be null");
        Assert.hasText((String)typeName, (String)"Target type name must not be null or empty");
        try {
            return ClassUtils.forName((String)typeName, (ClassLoader)classLoader).isInstance(source);
        }
        catch (Exception exception) {
            return false;
        }
    }
}

