/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security.hash;

import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.crypto.generators.Argon2BytesGenerator;
import org.bouncycastle.crypto.params.Argon2Parameters;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.security.codec.AbstractCodec;
import org.exoplatform.web.security.codec.CodecInitializer;
import org.exoplatform.web.security.security.TokenServiceInitializationException;
import org.picketlink.idm.api.Attribute;
import org.picketlink.idm.api.AttributesManager;
import org.picketlink.idm.api.SecureRandomProvider;
import org.picketlink.idm.common.exception.IdentityException;
import org.picketlink.idm.impl.credential.HashingEncoder;

public class Argon2IdPasswordEncoder
extends HashingEncoder {
    private static final Log LOG = ExoLogger.getLogger(Argon2IdPasswordEncoder.class);
    private static final String PASSWORD_SALT_USER_ATTRIBUTE = "passwordSalt128";
    private static final int ARGON2_HASHING_ITERATIONS = 2;
    private static final int ARGON2_MEMORY_LIMIT = 32768;
    private static final int ARGON2_PARALLEL_EXECUTIONS = 2;
    private static final int ARGON2_HASH_LENGTH = 32;
    private static final String OPTION_CREDENTIAL_ENCODER_SECURE_RANDOM_ALGORITHM = "credentialEncoder.secureRandomAlgorithm";
    private static final String OPTION_DEFAULT_SECURE_RANDOM_ALGORITHM = "SHA1PRNG";
    public static final String OPTION_SECURE_RANDOM_PROVIDER_REGISTRY_NAME = "credentialEncoder.secureRandom.providerRegistryName";
    public static final String DEFAULT_SECURE_RANDOM_PROVIDER_REGISTRY_NAME = "secureRandomProvider";
    private SecureRandomProvider registeredSecureRandomProvider;
    private String secureRandomAlgorithm;
    private static CodecInitializer codecInitializer;

    public String encodeCredential(String username, String rawPassword) {
        Argon2Parameters.Builder builder = new Argon2Parameters.Builder(2).withIterations(2).withMemoryAsKB(32768).withParallelism(2).withSalt(this.getStoredSalt(username));
        Argon2BytesGenerator generator = new Argon2BytesGenerator();
        generator.init(builder.build());
        byte[] hash = new byte[32];
        generator.generateBytes(rawPassword.getBytes(StandardCharsets.UTF_8), hash, 0, hash.length);
        try {
            return Argon2IdPasswordEncoder.getCodec().encode(Hex.encodeHexString((byte[])hash));
        }
        catch (TokenServiceInitializationException e) {
            LOG.error((Object)"Error while applying symmetrical encryption on password hash", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private String getRegisteredProviderName() {
        String registeredName = this.getEncoderProperty(OPTION_SECURE_RANDOM_PROVIDER_REGISTRY_NAME);
        if (registeredName == null) {
            registeredName = DEFAULT_SECURE_RANDOM_PROVIDER_REGISTRY_NAME;
        }
        return registeredName;
    }

    protected void afterInitialize() {
        super.afterInitialize();
        try {
            if (this.getConfigurationRegistry() != null) {
                this.registeredSecureRandomProvider = (SecureRandomProvider)this.getConfigurationRegistry().getObject(this.getRegisteredProviderName());
                LOG.info((Object)"Registered SecureRandomProvider will be used for random generating of password salts");
                return;
            }
        }
        catch (IdentityException ie) {
            LOG.info((Object)"SecureRandomProvider not registered. We will always create new SecureRandom");
        }
        this.secureRandomAlgorithm = this.getEncoderProperty(OPTION_CREDENTIAL_ENCODER_SECURE_RANDOM_ALGORITHM);
        if (this.secureRandomAlgorithm == null) {
            this.secureRandomAlgorithm = OPTION_DEFAULT_SECURE_RANDOM_ALGORITHM;
        }
        LOG.info("Algorithm {} will be used for random generating of password salts", new Object[]{this.secureRandomAlgorithm});
    }

    private byte[] getStoredSalt(String username) {
        try {
            AttributesManager attributesManager = this.getIdentitySession().getAttributesManager();
            Attribute salt = attributesManager.getAttribute(username, PASSWORD_SALT_USER_ATTRIBUTE);
            if (salt == null) {
                byte[] generatedSalt = this.generateRandomSalt();
                String saltString = Hex.encodeHexString((byte[])generatedSalt);
                attributesManager.addAttribute(username, PASSWORD_SALT_USER_ATTRIBUTE, (Object)saltString);
                return generatedSalt;
            }
            return Hex.decodeHex((char[])((String)salt.getValue()).toCharArray());
        }
        catch (Exception e) {
            LOG.error((Object)"Error while getting stored password hash salt", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public byte[] generateRandomSalt() throws NoSuchAlgorithmException {
        SecureRandom secureRandom = this.getSecureRandomInstance();
        byte[] salt = new byte[16];
        secureRandom.nextBytes(salt);
        return salt;
    }

    private static AbstractCodec getCodec() throws TokenServiceInitializationException {
        if (codecInitializer == null) {
            PortalContainer container = PortalContainer.getInstance();
            codecInitializer = (CodecInitializer)container.getComponentInstanceOfType(CodecInitializer.class);
            return codecInitializer.getCodec();
        }
        return codecInitializer.getCodec();
    }

    private SecureRandom getSecureRandomInstance() throws NoSuchAlgorithmException {
        if (this.registeredSecureRandomProvider == null) {
            return SecureRandom.getInstance(this.secureRandomAlgorithm);
        }
        return this.registeredSecureRandomProvider.getSecureRandom();
    }
}

