/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ccr;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.ccr.PutAutoFollowPatternResponse;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutAutoFollowPatternRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String followIndexPattern;
    private final List<String> leaderIndexExclusionPatterns;
    private final List<String> leaderIndexPatterns;
    @Nullable
    private final Time masterTimeout;
    @Nullable
    private final Integer maxOutstandingReadRequests;
    @Nullable
    private final Integer maxOutstandingWriteRequests;
    @Nullable
    private final Integer maxReadRequestOperationCount;
    @Nullable
    private final String maxReadRequestSize;
    @Nullable
    private final Time maxRetryDelay;
    @Nullable
    private final Integer maxWriteBufferCount;
    @Nullable
    private final String maxWriteBufferSize;
    @Nullable
    private final Integer maxWriteRequestOperationCount;
    @Nullable
    private final String maxWriteRequestSize;
    private final String name;
    @Nullable
    private final Time readPollTimeout;
    private final String remoteCluster;
    private final Map<String, JsonData> settings;
    public static final JsonpDeserializer<PutAutoFollowPatternRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutAutoFollowPatternRequest::setupPutAutoFollowPatternRequestDeserializer);
    public static final Endpoint<PutAutoFollowPatternRequest, PutAutoFollowPatternResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutAutoFollowPatternRequest, PutAutoFollowPatternResponse>("es/ccr.put_auto_follow_pattern", request -> "PUT", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ccr");
            buf.append("/auto_follow");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("name", request.name);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutAutoFollowPatternResponse._DESERIALIZER);

    private PutAutoFollowPatternRequest(Builder builder) {
        this.followIndexPattern = builder.followIndexPattern;
        this.leaderIndexExclusionPatterns = ApiTypeHelper.unmodifiable(builder.leaderIndexExclusionPatterns);
        this.leaderIndexPatterns = ApiTypeHelper.unmodifiable(builder.leaderIndexPatterns);
        this.masterTimeout = builder.masterTimeout;
        this.maxOutstandingReadRequests = builder.maxOutstandingReadRequests;
        this.maxOutstandingWriteRequests = builder.maxOutstandingWriteRequests;
        this.maxReadRequestOperationCount = builder.maxReadRequestOperationCount;
        this.maxReadRequestSize = builder.maxReadRequestSize;
        this.maxRetryDelay = builder.maxRetryDelay;
        this.maxWriteBufferCount = builder.maxWriteBufferCount;
        this.maxWriteBufferSize = builder.maxWriteBufferSize;
        this.maxWriteRequestOperationCount = builder.maxWriteRequestOperationCount;
        this.maxWriteRequestSize = builder.maxWriteRequestSize;
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.readPollTimeout = builder.readPollTimeout;
        this.remoteCluster = ApiTypeHelper.requireNonNull(builder.remoteCluster, this, "remoteCluster");
        this.settings = ApiTypeHelper.unmodifiable(builder.settings);
    }

    public static PutAutoFollowPatternRequest of(Function<Builder, ObjectBuilder<PutAutoFollowPatternRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String followIndexPattern() {
        return this.followIndexPattern;
    }

    public final List<String> leaderIndexExclusionPatterns() {
        return this.leaderIndexExclusionPatterns;
    }

    public final List<String> leaderIndexPatterns() {
        return this.leaderIndexPatterns;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public final Integer maxOutstandingReadRequests() {
        return this.maxOutstandingReadRequests;
    }

    @Nullable
    public final Integer maxOutstandingWriteRequests() {
        return this.maxOutstandingWriteRequests;
    }

    @Nullable
    public final Integer maxReadRequestOperationCount() {
        return this.maxReadRequestOperationCount;
    }

    @Nullable
    public final String maxReadRequestSize() {
        return this.maxReadRequestSize;
    }

    @Nullable
    public final Time maxRetryDelay() {
        return this.maxRetryDelay;
    }

    @Nullable
    public final Integer maxWriteBufferCount() {
        return this.maxWriteBufferCount;
    }

    @Nullable
    public final String maxWriteBufferSize() {
        return this.maxWriteBufferSize;
    }

    @Nullable
    public final Integer maxWriteRequestOperationCount() {
        return this.maxWriteRequestOperationCount;
    }

    @Nullable
    public final String maxWriteRequestSize() {
        return this.maxWriteRequestSize;
    }

    public final String name() {
        return this.name;
    }

    @Nullable
    public final Time readPollTimeout() {
        return this.readPollTimeout;
    }

    public final String remoteCluster() {
        return this.remoteCluster;
    }

    public final Map<String, JsonData> settings() {
        return this.settings;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.followIndexPattern != null) {
            generator.writeKey("follow_index_pattern");
            generator.write(this.followIndexPattern);
        }
        if (ApiTypeHelper.isDefined(this.leaderIndexExclusionPatterns)) {
            generator.writeKey("leader_index_exclusion_patterns");
            generator.writeStartArray();
            for (String string : this.leaderIndexExclusionPatterns) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.leaderIndexPatterns)) {
            generator.writeKey("leader_index_patterns");
            generator.writeStartArray();
            for (String string : this.leaderIndexPatterns) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.maxOutstandingReadRequests != null) {
            generator.writeKey("max_outstanding_read_requests");
            generator.write(this.maxOutstandingReadRequests.intValue());
        }
        if (this.maxOutstandingWriteRequests != null) {
            generator.writeKey("max_outstanding_write_requests");
            generator.write(this.maxOutstandingWriteRequests.intValue());
        }
        if (this.maxReadRequestOperationCount != null) {
            generator.writeKey("max_read_request_operation_count");
            generator.write(this.maxReadRequestOperationCount.intValue());
        }
        if (this.maxReadRequestSize != null) {
            generator.writeKey("max_read_request_size");
            generator.write(this.maxReadRequestSize);
        }
        if (this.maxRetryDelay != null) {
            generator.writeKey("max_retry_delay");
            this.maxRetryDelay.serialize(generator, mapper);
        }
        if (this.maxWriteBufferCount != null) {
            generator.writeKey("max_write_buffer_count");
            generator.write(this.maxWriteBufferCount.intValue());
        }
        if (this.maxWriteBufferSize != null) {
            generator.writeKey("max_write_buffer_size");
            generator.write(this.maxWriteBufferSize);
        }
        if (this.maxWriteRequestOperationCount != null) {
            generator.writeKey("max_write_request_operation_count");
            generator.write(this.maxWriteRequestOperationCount.intValue());
        }
        if (this.maxWriteRequestSize != null) {
            generator.writeKey("max_write_request_size");
            generator.write(this.maxWriteRequestSize);
        }
        if (this.readPollTimeout != null) {
            generator.writeKey("read_poll_timeout");
            this.readPollTimeout.serialize(generator, mapper);
        }
        generator.writeKey("remote_cluster");
        generator.write(this.remoteCluster);
        if (ApiTypeHelper.isDefined(this.settings)) {
            generator.writeKey("settings");
            generator.writeStartObject();
            for (Map.Entry entry : this.settings.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupPutAutoFollowPatternRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::followIndexPattern, JsonpDeserializer.stringDeserializer(), "follow_index_pattern");
        op.add(Builder::leaderIndexExclusionPatterns, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "leader_index_exclusion_patterns");
        op.add(Builder::leaderIndexPatterns, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "leader_index_patterns");
        op.add(Builder::maxOutstandingReadRequests, JsonpDeserializer.integerDeserializer(), "max_outstanding_read_requests");
        op.add(Builder::maxOutstandingWriteRequests, JsonpDeserializer.integerDeserializer(), "max_outstanding_write_requests");
        op.add(Builder::maxReadRequestOperationCount, JsonpDeserializer.integerDeserializer(), "max_read_request_operation_count");
        op.add(Builder::maxReadRequestSize, JsonpDeserializer.stringDeserializer(), "max_read_request_size");
        op.add(Builder::maxRetryDelay, Time._DESERIALIZER, "max_retry_delay");
        op.add(Builder::maxWriteBufferCount, JsonpDeserializer.integerDeserializer(), "max_write_buffer_count");
        op.add(Builder::maxWriteBufferSize, JsonpDeserializer.stringDeserializer(), "max_write_buffer_size");
        op.add(Builder::maxWriteRequestOperationCount, JsonpDeserializer.integerDeserializer(), "max_write_request_operation_count");
        op.add(Builder::maxWriteRequestSize, JsonpDeserializer.stringDeserializer(), "max_write_request_size");
        op.add(Builder::readPollTimeout, Time._DESERIALIZER, "read_poll_timeout");
        op.add(Builder::remoteCluster, JsonpDeserializer.stringDeserializer(), "remote_cluster");
        op.add(Builder::settings, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "settings");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutAutoFollowPatternRequest> {
        @Nullable
        private String followIndexPattern;
        @Nullable
        private List<String> leaderIndexExclusionPatterns;
        @Nullable
        private List<String> leaderIndexPatterns;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private Integer maxOutstandingReadRequests;
        @Nullable
        private Integer maxOutstandingWriteRequests;
        @Nullable
        private Integer maxReadRequestOperationCount;
        @Nullable
        private String maxReadRequestSize;
        @Nullable
        private Time maxRetryDelay;
        @Nullable
        private Integer maxWriteBufferCount;
        @Nullable
        private String maxWriteBufferSize;
        @Nullable
        private Integer maxWriteRequestOperationCount;
        @Nullable
        private String maxWriteRequestSize;
        private String name;
        @Nullable
        private Time readPollTimeout;
        private String remoteCluster;
        @Nullable
        private Map<String, JsonData> settings;

        public final Builder followIndexPattern(@Nullable String value) {
            this.followIndexPattern = value;
            return this;
        }

        public final Builder leaderIndexExclusionPatterns(List<String> list) {
            this.leaderIndexExclusionPatterns = Builder._listAddAll(this.leaderIndexExclusionPatterns, list);
            return this;
        }

        public final Builder leaderIndexExclusionPatterns(String value, String ... values) {
            this.leaderIndexExclusionPatterns = Builder._listAdd(this.leaderIndexExclusionPatterns, value, values);
            return this;
        }

        public final Builder leaderIndexPatterns(List<String> list) {
            this.leaderIndexPatterns = Builder._listAddAll(this.leaderIndexPatterns, list);
            return this;
        }

        public final Builder leaderIndexPatterns(String value, String ... values) {
            this.leaderIndexPatterns = Builder._listAdd(this.leaderIndexPatterns, value, values);
            return this;
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder maxOutstandingReadRequests(@Nullable Integer value) {
            this.maxOutstandingReadRequests = value;
            return this;
        }

        public final Builder maxOutstandingWriteRequests(@Nullable Integer value) {
            this.maxOutstandingWriteRequests = value;
            return this;
        }

        public final Builder maxReadRequestOperationCount(@Nullable Integer value) {
            this.maxReadRequestOperationCount = value;
            return this;
        }

        public final Builder maxReadRequestSize(@Nullable String value) {
            this.maxReadRequestSize = value;
            return this;
        }

        public final Builder maxRetryDelay(@Nullable Time value) {
            this.maxRetryDelay = value;
            return this;
        }

        public final Builder maxRetryDelay(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.maxRetryDelay(fn.apply(new Time.Builder()).build());
        }

        public final Builder maxWriteBufferCount(@Nullable Integer value) {
            this.maxWriteBufferCount = value;
            return this;
        }

        public final Builder maxWriteBufferSize(@Nullable String value) {
            this.maxWriteBufferSize = value;
            return this;
        }

        public final Builder maxWriteRequestOperationCount(@Nullable Integer value) {
            this.maxWriteRequestOperationCount = value;
            return this;
        }

        public final Builder maxWriteRequestSize(@Nullable String value) {
            this.maxWriteRequestSize = value;
            return this;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder readPollTimeout(@Nullable Time value) {
            this.readPollTimeout = value;
            return this;
        }

        public final Builder readPollTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.readPollTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder remoteCluster(String value) {
            this.remoteCluster = value;
            return this;
        }

        public final Builder settings(Map<String, JsonData> map) {
            this.settings = Builder._mapPutAll(this.settings, map);
            return this;
        }

        public final Builder settings(String key, JsonData value) {
            this.settings = Builder._mapPut(this.settings, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutAutoFollowPatternRequest build() {
            this._checkSingleUse();
            return new PutAutoFollowPatternRequest(this);
        }
    }
}

