/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.integration;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.gatein.sso.integration.SSOUtils;

public class SSODelegateLoginModule
implements LoginModule {
    private static final String OPTION_DELEGATE_CLASSNAME = "delegateClassName";
    private static final String OPTION_ENABLED = "enabled";
    private static final ConcurrentMap<String, Class<LoginModule>> delegateClasses = new ConcurrentHashMap<String, Class<LoginModule>>();
    private static final Log log = ExoLogger.getLogger(SSODelegateLoginModule.class);
    private LoginModule delegate;
    private boolean enabled;

    private static Class<LoginModule> getOrLoadDelegateClass(String className) {
        Class<?> clazz = (Class<?>)delegateClasses.get(className);
        if (clazz == null) {
            clazz = SSOUtils.loadClass(className);
            delegateClasses.putIfAbsent(className, clazz);
            log.debug((Object)("Class " + className + " loaded successfully"));
        }
        return clazz;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        String enabledParam = (String)options.get(OPTION_ENABLED);
        enabledParam = this.substituteSystemProperty(enabledParam);
        this.enabled = Boolean.parseBoolean(enabledParam);
        if (!this.enabled) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"SSO is disabled. Ignore login module");
            }
            return;
        }
        String delegateClazz = (String)options.get(OPTION_DELEGATE_CLASSNAME);
        if ((delegateClazz = this.substituteSystemProperty(delegateClazz)) == null) {
            throw new IllegalArgumentException("Option 'delegateClassName' is not available");
        }
        Class<LoginModule> delegateClass = SSODelegateLoginModule.getOrLoadDelegateClass(delegateClazz);
        try {
            this.delegate = delegateClass.newInstance();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Delegating login module created successfully: " + String.valueOf(this.delegate)));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Can't instantiate " + String.valueOf(delegateClass), e);
        }
        options = this.removeUnneededOptions(options);
        this.delegate.initialize(subject, callbackHandler, sharedState, options);
    }

    private Map<String, ?> removeUnneededOptions(Map<String, ?> oldMap) {
        HashMap newMap = new HashMap();
        newMap.putAll(oldMap);
        newMap.remove(OPTION_DELEGATE_CLASSNAME);
        newMap.remove(OPTION_ENABLED);
        return newMap;
    }

    @Override
    public boolean login() throws LoginException {
        return this.enabled ? this.delegate.login() : false;
    }

    @Override
    public boolean commit() throws LoginException {
        return this.enabled ? this.delegate.commit() : false;
    }

    @Override
    public boolean abort() throws LoginException {
        return this.enabled ? this.delegate.abort() : false;
    }

    @Override
    public boolean logout() throws LoginException {
        return this.enabled ? this.delegate.logout() : false;
    }

    private String substituteSystemProperty(String prop) {
        if (prop == null) {
            return prop;
        }
        prop = prop.replace('#', '$');
        return SSOUtils.substituteSystemProperty(prop);
    }
}

