/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.analytics.model.filter.aggregation;

import groovy.transform.ToString;
import io.meeds.analytics.model.filter.aggregation.AnalyticsAggregationType;
import io.meeds.analytics.utils.AnalyticsUtils;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

@ToString
public class AnalyticsAggregation
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 2130321038232532587L;
    public static final String YEAR_INTERVAL = "year";
    public static final String MONTH_INTERVAL = "month";
    public static final String QUARTER_INTERVAL = "quarter";
    public static final String WEEK_INTERVAL = "week";
    public static final String DAY_INTERVAL = "day";
    public static final String HOUR_INTERVAL = "hour";
    public static final String MINUTE_INTERVAL = "minute";
    public static final String SECOND_INTERVAL = "second";
    public static final List<String> ALL_INTERVALS = Collections.unmodifiableList(Arrays.asList("year", "quarter", "month", "week", "day", "hour", "minute"));
    public static final DateTimeFormatter YEAR_DATE_FORMATTER = DateTimeFormatter.ofPattern("uuuu");
    public static final DateTimeFormatter QUARTER_DATE_FORMATTER = DateTimeFormatter.ofPattern("QQQ uuuu");
    public static final DateTimeFormatter MONTH_DATE_FORMATTER = DateTimeFormatter.ofPattern("MMM uuuu");
    public static final DateTimeFormatter DAY_DATE_FORMATTER = DateTimeFormatter.ofPattern("d MMM uuuu");
    public static final DateTimeFormatter WEEK_DATE_FORMATTER = DateTimeFormatter.ISO_WEEK_DATE;
    public static final DateTimeFormatter HOUR_DATE_FORMATTER = DateTimeFormatter.ofPattern("hh a, d MMM uuuu");
    private AnalyticsAggregationType type;
    private String field;
    private String sortDirection;
    private String interval;
    private String offset;
    private long limit;
    private boolean useBounds;
    private long minBound;
    private long maxBound;

    public AnalyticsAggregation(AnalyticsAggregationType type, String field, String sortDirection, String interval, long limit) {
        this.type = type;
        this.field = field;
        this.sortDirection = sortDirection;
        this.interval = interval;
        this.limit = limit;
    }

    public AnalyticsAggregation(String field) {
        this.field = field;
        this.type = AnalyticsAggregationType.TERMS;
    }

    public String getSortDirection() {
        if (this.sortDirection == null) {
            return this.type == AnalyticsAggregationType.DATE ? "asc" : "desc";
        }
        return this.sortDirection;
    }

    public String getLabel(String fieldValue, ZoneId zoneId, String lang) {
        long timestamp = Long.parseLong(fieldValue);
        return this.formatTime(timestamp, zoneId, lang);
    }

    public String getLabel(String fieldValue) {
        return AnalyticsUtils.compueLabel(this.field, fieldValue);
    }

    private String formatTime(long timestamp, ZoneId zoneId, String lang) {
        Locale userLocale = StringUtils.isBlank((CharSequence)lang) ? Locale.getDefault() : Locale.forLanguageTag(lang);
        LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), zoneId);
        DateTimeFormatter dateFormatter = null;
        switch (this.interval) {
            case "year": {
                dateFormatter = YEAR_DATE_FORMATTER;
                break;
            }
            case "quarter": {
                dateFormatter = QUARTER_DATE_FORMATTER;
                break;
            }
            case "month": {
                dateFormatter = MONTH_DATE_FORMATTER;
                break;
            }
            case "week": {
                dateFormatter = WEEK_DATE_FORMATTER;
                break;
            }
            case "day": {
                dateFormatter = DAY_DATE_FORMATTER;
                break;
            }
            case "hour": {
                dateFormatter = HOUR_DATE_FORMATTER;
                break;
            }
            default: {
                dateFormatter = DAY_DATE_FORMATTER;
            }
        }
        Object dateFormated = dateTime.format(dateFormatter.withLocale(userLocale));
        if (this.interval.equals(WEEK_INTERVAL)) {
            String[] date = ((String)dateFormated).split("-");
            dateFormated = date[1] + "-" + date[0];
        }
        return dateFormated;
    }

    public AnalyticsAggregation clone() {
        return new AnalyticsAggregation(this.type, this.field, this.sortDirection, this.interval, this.offset, this.limit, this.useBounds, this.minBound, this.maxBound);
    }

    @Generated
    public AnalyticsAggregationType getType() {
        return this.type;
    }

    @Generated
    public String getField() {
        return this.field;
    }

    @Generated
    public String getInterval() {
        return this.interval;
    }

    @Generated
    public String getOffset() {
        return this.offset;
    }

    @Generated
    public long getLimit() {
        return this.limit;
    }

    @Generated
    public boolean isUseBounds() {
        return this.useBounds;
    }

    @Generated
    public long getMinBound() {
        return this.minBound;
    }

    @Generated
    public long getMaxBound() {
        return this.maxBound;
    }

    @Generated
    public void setType(AnalyticsAggregationType type) {
        this.type = type;
    }

    @Generated
    public void setField(String field) {
        this.field = field;
    }

    @Generated
    public void setSortDirection(String sortDirection) {
        this.sortDirection = sortDirection;
    }

    @Generated
    public void setInterval(String interval) {
        this.interval = interval;
    }

    @Generated
    public void setOffset(String offset) {
        this.offset = offset;
    }

    @Generated
    public void setLimit(long limit) {
        this.limit = limit;
    }

    @Generated
    public void setUseBounds(boolean useBounds) {
        this.useBounds = useBounds;
    }

    @Generated
    public void setMinBound(long minBound) {
        this.minBound = minBound;
    }

    @Generated
    public void setMaxBound(long maxBound) {
        this.maxBound = maxBound;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnalyticsAggregation)) {
            return false;
        }
        AnalyticsAggregation other = (AnalyticsAggregation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AnalyticsAggregationType this$type = this.getType();
        AnalyticsAggregationType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$field = this.getField();
        String other$field = other.getField();
        if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
            return false;
        }
        String this$interval = this.getInterval();
        String other$interval = other.getInterval();
        return !(this$interval == null ? other$interval != null : !this$interval.equals(other$interval));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AnalyticsAggregation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AnalyticsAggregationType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        String $interval = this.getInterval();
        result = result * 59 + ($interval == null ? 43 : $interval.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AnalyticsAggregation(type=" + String.valueOf((Object)this.getType()) + ", field=" + this.getField() + ", sortDirection=" + this.getSortDirection() + ", interval=" + this.getInterval() + ", offset=" + this.getOffset() + ", limit=" + this.getLimit() + ", useBounds=" + this.isUseBounds() + ", minBound=" + this.getMinBound() + ", maxBound=" + this.getMaxBound() + ")";
    }

    @Generated
    public AnalyticsAggregation(AnalyticsAggregationType type, String field, String sortDirection, String interval, String offset, long limit, boolean useBounds, long minBound, long maxBound) {
        this.type = type;
        this.field = field;
        this.sortDirection = sortDirection;
        this.interval = interval;
        this.offset = offset;
        this.limit = limit;
        this.useBounds = useBounds;
        this.minBound = minBound;
        this.maxBound = maxBound;
    }

    @Generated
    public AnalyticsAggregation() {
    }
}

