/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl.jpa.email;

import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.service.QueueMessage;
import org.exoplatform.commons.api.persistence.DataInitializer;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.notification.NotificationContextFactory;
import org.exoplatform.commons.notification.NotificationUtils;
import org.exoplatform.commons.notification.impl.jpa.email.JPAQueueMessageImpl$AjcClosure1;
import org.exoplatform.commons.notification.impl.jpa.email.JPAQueueMessageImpl$AjcClosure3;
import org.exoplatform.commons.notification.impl.jpa.email.dao.MailQueueDAO;
import org.exoplatform.commons.notification.impl.jpa.email.entity.MailQueueEntity;
import org.exoplatform.commons.notification.impl.service.MailQueueMessageManager;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.management.annotations.ManagedBy;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.mail.MailService;
import org.picocontainer.Startable;

@ManagedBy(value=MailQueueMessageManager.class)
public class JPAQueueMessageImpl
implements QueueMessage,
Startable {
    private static final Log LOG;
    private static final String MAX_TO_SEND_SYS_KEY = "conf.notification.service.QueueMessage.numberOfMailPerBatch";
    private static final String MAX_TO_SEND_KEY = "numberOfMailPerBatch";
    private static final int MAX_TO_SEND_DEFAULT = 20;
    private boolean enabled = true;
    private int maxToSend;
    private MailService mailService;
    private MailQueueDAO mailQueueDAO;
    private ListenerService listenerService;
    private NotificationContextFactory notificationContextFactory;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public JPAQueueMessageImpl(MailService mailService, MailQueueDAO mailQueueDAO, ListenerService listenerService, DataInitializer dataInitializer, NotificationContextFactory notificationContextFactory, InitParams params) {
        this.mailService = mailService;
        this.mailQueueDAO = mailQueueDAO;
        this.listenerService = listenerService;
        this.notificationContextFactory = notificationContextFactory;
        this.maxToSend = NotificationUtils.getSystemValue(params, MAX_TO_SEND_SYS_KEY, MAX_TO_SEND_KEY, 20);
    }

    public void enable(boolean enabled) {
        this.enabled = enabled;
    }

    public void start() {
    }

    public void stop() {
    }

    @ExoTransactional
    public boolean put(MessageInfo message) throws Exception {
        MessageInfo messageInfo = message;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)messageInfo);
        Object[] objectArray = new Object[]{this, messageInfo, joinPoint};
        JPAQueueMessageImpl$AjcClosure1 jPAQueueMessageImpl$AjcClosure1 = new JPAQueueMessageImpl$AjcClosure1(objectArray);
        return Conversions.booleanValue((Object)ExoTransactionalAspect.aspectOf().around(jPAQueueMessageImpl$AjcClosure1.linkClosureAndJoinPoint(69648)));
    }

    @ExoTransactional
    public void send() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        JPAQueueMessageImpl$AjcClosure3 jPAQueueMessageImpl$AjcClosure3 = new JPAQueueMessageImpl$AjcClosure3(objectArray);
        ExoTransactionalAspect.aspectOf().around(jPAQueueMessageImpl$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    public boolean sendMessage(MessageInfo message) throws Exception {
        if (message == null) {
            throw new IllegalArgumentException("Message is null");
        }
        if (message.getFrom() == null) {
            throw new IllegalStateException("Message with id '" + message.getId() + "' has an empty 'from' field");
        }
        if (this.enabled) {
            this.mailService.sendMessage(message.makeEmailNotification());
            return true;
        }
        this.listenerService.broadcast(new Event("MESSAGE_SENT_FROM_QUEUE", (Object)this, (Object)message.getId()));
        return true;
    }

    public void removeAll() {
        LOG.debug((Object)"Removing messages: ");
        this.mailQueueDAO.deleteAll();
        LOG.debug((Object)"Done to removed messages! ");
    }

    private void saveMessageInfo(MessageInfo message) {
        MailQueueEntity mailQueueEntity = new MailQueueEntity();
        mailQueueEntity.setType(message.getPluginId());
        mailQueueEntity.setFrom(message.getFrom());
        mailQueueEntity.setTo(message.getTo());
        mailQueueEntity.setSubject(message.getSubject());
        mailQueueEntity.setBody(message.getBody());
        mailQueueEntity.setFooter(message.getFooter());
        mailQueueEntity.setCreationDate(Calendar.getInstance());
        this.mailQueueDAO.create(mailQueueEntity);
    }

    private Set<MessageInfo> load() {
        HashSet<MessageInfo> messages = new HashSet<MessageInfo>();
        for (MailQueueEntity mailQueueEntity : this.mailQueueDAO.findAll(0, this.maxToSend)) {
            try {
                messages.add(JPAQueueMessageImpl.convertQueueEntityToMessageInfo(mailQueueEntity));
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to load message with id = " + mailQueueEntity.getId()), (Throwable)e);
            }
        }
        return messages;
    }

    private static MessageInfo convertQueueEntityToMessageInfo(MailQueueEntity mailQueueEntity) {
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setId(String.valueOf(mailQueueEntity.getId()));
        messageInfo.pluginId(mailQueueEntity.getType());
        messageInfo.from(mailQueueEntity.getFrom());
        messageInfo.to(mailQueueEntity.getTo());
        messageInfo.subject(mailQueueEntity.getSubject());
        messageInfo.body(mailQueueEntity.getBody());
        messageInfo.footer(mailQueueEntity.getFooter());
        messageInfo.setCreatedTime(mailQueueEntity.getCreationDate().getTimeInMillis());
        return messageInfo;
    }

    private void removeMessageInfo(String id) throws Exception {
        LOG.debug((Object)("Removing messageId: " + id));
        this.mailQueueDAO.delete((MailQueueEntity)this.mailQueueDAO.find(Long.valueOf(Long.parseLong(id))));
        this.listenerService.broadcast(new Event("MESSAGE_DELETED_FROM_QUEUE", (Object)this, (Object)id));
    }

    static {
        JPAQueueMessageImpl.ajc$preClinit();
        LOG = ExoLogger.getExoLogger(JPAQueueMessageImpl.class);
    }

    static final /* synthetic */ boolean put_aroundBody0(JPAQueueMessageImpl ajc$this, MessageInfo message, JoinPoint joinPoint) {
        if (message == null || message.getTo() == null || message.getTo().length() == 0) {
            return false;
        }
        if (!NotificationUtils.isValidEmailAddresses(message.getTo())) {
            LOG.warn((Object)String.format("The email %s is not valid for sending notification", message.getTo()));
            return false;
        }
        ajc$this.saveMessageInfo(message);
        ajc$this.listenerService.broadcast(new Event("MESSAGE_SENT_FROM_QUEUE", (Object)ajc$this, (Object)message.getId()));
        return true;
    }

    static final /* synthetic */ void send_aroundBody2(JPAQueueMessageImpl ajc$this, JoinPoint joinPoint) {
        boolean statsEnabled = ajc$this.notificationContextFactory.getStatistics().isStatisticsEnabled();
        int messagesSize = 0;
        Set<MessageInfo> messages = ajc$this.load();
        int originalMessagesSize = messages.size();
        messagesSize = originalMessagesSize;
        if (messagesSize > 0) {
            LOG.info((Object)(messagesSize + " message(s) will be sent."));
        }
        for (MessageInfo messageInfo : messages) {
            if (messageInfo == null) continue;
            try {
                if (!ajc$this.sendMessage(messageInfo)) continue;
                LOG.debug("Mail message '{}' sent to user: {}", new Object[]{messageInfo.getId(), messageInfo.getTo()});
                ajc$this.removeMessageInfo(messageInfo.getId());
                LOG.debug("Mail message '{}' removed from queue, to user: {}", new Object[]{messageInfo.getId(), messageInfo.getTo()});
                if (!statsEnabled) continue;
                ajc$this.notificationContextFactory.getStatisticsCollector().pollQueue(messageInfo.getPluginId());
            }
            catch (Exception e) {
                --messagesSize;
                LOG.error((Object)("Error sending message from = '" + messageInfo.getFrom() + "', to = '" + messageInfo.getTo() + "', id = '" + messageInfo.getId() + "'"), (Throwable)e);
            }
        }
        if (originalMessagesSize > 0) {
            LOG.info("{}/{} message(s) are loaded, sent and deleted from queue.", new Object[]{messagesSize, originalMessagesSize});
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JPAQueueMessageImpl.java", JPAQueueMessageImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "put", "org.exoplatform.commons.notification.impl.jpa.email.JPAQueueMessageImpl", "org.exoplatform.commons.api.notification.model.MessageInfo", "message", "java.lang.Exception", "boolean"), 108);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "send", "org.exoplatform.commons.notification.impl.jpa.email.JPAQueueMessageImpl", "", "", "", "void"), 130);
    }
}

