/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.twitter.gamification.storage;

import io.meeds.twitter.gamification.dao.TwitterTweetDAO;
import io.meeds.twitter.gamification.entity.TwitterTweetEntity;
import io.meeds.twitter.gamification.model.Tweet;
import io.meeds.twitter.gamification.storage.mapper.TwitterTweetMapper;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository
public class TwitterTweetStorage {
    @Autowired
    private TwitterTweetDAO twitterTweetDAO;

    public Tweet addTweetToWatch(Tweet tweet) {
        Tweet existsTweet = this.getTweetByLink(tweet.getTweetLink());
        if (existsTweet == null) {
            TwitterTweetEntity twitterTweetEntity = TwitterTweetMapper.toEntity(tweet);
            twitterTweetEntity = (TwitterTweetEntity)this.twitterTweetDAO.save(twitterTweetEntity);
            return TwitterTweetMapper.fromEntity(twitterTweetEntity);
        }
        return null;
    }

    public Tweet updateTweetReactions(long tweetId, Set<String> likers, Set<String> retweeters) {
        TwitterTweetEntity twitterTweetEntity = this.twitterTweetDAO.findById(tweetId).orElse(null);
        if (twitterTweetEntity == null) {
            return null;
        }
        twitterTweetEntity.setLikers(likers);
        twitterTweetEntity.setRetweeters(retweeters);
        return TwitterTweetMapper.fromEntity((TwitterTweetEntity)this.twitterTweetDAO.save(twitterTweetEntity));
    }

    public Page<Tweet> getTweets(Pageable pageable) {
        Page page = this.twitterTweetDAO.findAll(pageable);
        return page.map(TwitterTweetMapper::fromEntity);
    }

    public List<Tweet> getTweets() {
        List twitterTweetEntities = this.twitterTweetDAO.findAll();
        return twitterTweetEntities.stream().map(TwitterTweetMapper::fromEntity).toList();
    }

    public long countTweets() {
        return this.twitterTweetDAO.count();
    }

    public Tweet getTweetById(Long tweetId) {
        return TwitterTweetMapper.fromEntity(this.twitterTweetDAO.findById(tweetId).orElse(null));
    }

    public Tweet getTweetByLink(String tweetLink) {
        TwitterTweetEntity twitterTweetEntity = this.twitterTweetDAO.findTwitterTweetEntityByTweetLink(tweetLink);
        return TwitterTweetMapper.fromEntity(twitterTweetEntity);
    }

    public Tweet deleteTweet(long tweetId) {
        TwitterTweetEntity twitterTweetEntity = this.twitterTweetDAO.findById(tweetId).orElse(null);
        if (twitterTweetEntity != null) {
            this.twitterTweetDAO.delete(twitterTweetEntity);
        }
        return TwitterTweetMapper.fromEntity(twitterTweetEntity);
    }
}

