/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.plugin;

import io.meeds.gamification.constant.DateFilterType;
import io.meeds.gamification.constant.EntityStatusType;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.model.filter.RuleFilter;
import io.meeds.gamification.service.RuleService;
import io.meeds.social.cms.model.ContentLinkExtension;
import io.meeds.social.cms.model.ContentLinkSearchResult;
import io.meeds.social.cms.plugin.ContentLinkPlugin;
import io.meeds.social.cms.service.ContentLinkPluginService;
import io.meeds.social.translation.service.TranslationService;
import jakarta.annotation.PostConstruct;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RuleContentLinkPlugin
implements ContentLinkPlugin {
    public static final String OBJECT_TYPE = "rule";
    private static final String TITLE_KEY = "contentLink.action";
    private static final String ICON = "fa fa-trophy";
    private static final String COMMAND = "action";
    private static final ContentLinkExtension EXTENSION = new ContentLinkExtension("rule", "contentLink.action", "fa fa-trophy", "action", true);
    @Autowired
    private RuleService ruleService;
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private TranslationService translationService;
    @Autowired
    private UserACL userAcl;
    @Autowired
    private PortalContainer container;

    @PostConstruct
    public void init() {
        ((ContentLinkPluginService)this.container.getComponentInstanceOfType(ContentLinkPluginService.class)).addPlugin((ContentLinkPlugin)this);
    }

    public ContentLinkExtension getExtension() {
        return EXTENSION;
    }

    public List<ContentLinkSearchResult> search(String keyword, Identity identity, Locale locale, int offset, int limit) {
        RuleFilter filter = new RuleFilter();
        filter.setTerm(keyword);
        filter.setLocale(locale);
        filter.setDateFilterType(DateFilterType.ALL);
        filter.setProgramStatus(EntityStatusType.ENABLED);
        filter.setStatus(EntityStatusType.ENABLED);
        if (!this.userAcl.isAnonymousUser(identity)) {
            org.exoplatform.social.core.identity.model.Identity userIdentity = this.identityManager.getOrCreateUserIdentity(identity.getUserId());
            filter.setIdentityId(Long.parseLong(userIdentity.getId()));
        }
        return this.ruleService.getRules(filter, offset, limit).stream().map(r -> this.toContentLink((RuleDTO)r, locale)).toList();
    }

    public String getContentTitle(String objectId, Locale locale) {
        RuleDTO rule = this.ruleService.findRuleById(Long.parseLong(objectId));
        return rule == null || rule.isDeleted() ? null : this.getRuleTitle(rule, locale);
    }

    private ContentLinkSearchResult toContentLink(RuleDTO rule, Locale locale) {
        return new ContentLinkSearchResult(OBJECT_TYPE, String.valueOf(rule.getId()), this.getRuleTitle(rule, locale), EXTENSION.getIcon(), EXTENSION.isDrawer());
    }

    private String getRuleTitle(RuleDTO rule, Locale locale) {
        String translatedTitle = this.translationService.getTranslationLabelOrDefault(OBJECT_TYPE, rule.getId().longValue(), "title", locale);
        if (StringUtils.isNotBlank((CharSequence)translatedTitle)) {
            return translatedTitle;
        }
        return rule.getTitle();
    }
}

