/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.rest;

import io.meeds.gamification.model.RemoteConnector;
import io.meeds.gamification.model.RemoteConnectorSettings;
import io.meeds.gamification.rest.builder.ConnectorBuilder;
import io.meeds.gamification.rest.model.ConnectorRestEntity;
import io.meeds.gamification.service.ConnectorService;
import io.meeds.gamification.service.ConnectorSettingService;
import io.meeds.gamification.utils.Utils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.util.Collection;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;

@Path(value="/gamification/connectors")
public class ConnectorRest
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(ConnectorRest.class);
    private final ConnectorService connectorService;
    private final ConnectorSettingService connectorSettingService;

    public ConnectorRest(ConnectorService connectorService, ConnectorSettingService connectorSettingService) {
        this.connectorService = connectorService;
        this.connectorSettingService = connectorSettingService;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Retrieves the list of remote connectors", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation")})
    public Response getConnectors(@Parameter(description="Username", required=true) @QueryParam(value="username") String username, @Parameter(description="Used to retrieve extra information about connectors") @QueryParam(value="expand") String expand) {
        Identity identity = ConversationState.getCurrent().getIdentity();
        List<String> expandFields = Utils.getExpandOptions(expand);
        if (expandFields.contains("secretKey") && !this.connectorSettingService.canManageConnectorSettings(identity)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        List<ConnectorRestEntity> connectorRestEntities = this.getConnectorsRestEntities(expandFields, username);
        return Response.ok(connectorRestEntities).build();
    }

    @GET
    @Produces(value={"text/plain"})
    @RolesAllowed(value={"administrators"})
    @Path(value="username/{connectorName}")
    @Operation(summary="Retrieve the username associated with a connector user identifier.", description="Fetches the username corresponding to the given connector user identifier.", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="No associated username found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getUsernameByConnectorUserId(@Parameter(description="Connector name", required=true) @PathParam(value="connectorName") String connectorName, @Parameter(description="Connector user identifier", required=true) @QueryParam(value="connectorUserId") String connectorUserId) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{connectorName, connectorUserId})) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Both connector name and connector user identifier are required.").build();
        }
        String username = this.connectorService.getAssociatedUsername(connectorName, connectorUserId);
        if (StringUtils.isBlank((CharSequence)username)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No associated username found for the provided connector user identifier.").build();
        }
        return Response.ok((Object)username).build();
    }

    @GET
    @Produces(value={"text/html"})
    @RolesAllowed(value={"users"})
    @Path(value="oauthCallback/{connectorName}")
    @Operation(summary="Validate Remote user identifier on a selected connector and associate it in his current profile.", description="Validate Remote user identifier on a selected connector and associate it in his current profile.", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response connect(@Parameter(description="Connector name", required=true) @PathParam(value="connectorName") String connectorName, @Parameter(description="Access Token", required=true) @QueryParam(value="code") String code) {
        Identity identity = ConversationState.getCurrent().getIdentity();
        this.connectorService.connect(connectorName, null, code, identity);
        return Response.ok((Object)"<html><body><script type=text/javascript>window.close();</script></body></html>").build();
    }

    @DELETE
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="disconnect/{connectorName}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Deletes an existing connector account", description="Deletes an existing connector account", method="DELETE")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Object not found"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response disconnect(@Parameter(description="Connector name", required=true) @PathParam(value="connectorName") String connectorName, @Parameter(description="User Remote identifier", required=true) @FormParam(value="remoteId") String remoteId) {
        if (StringUtils.isBlank((CharSequence)connectorName)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"connector name is mandatory").build();
        }
        this.connectorService.disconnect(connectorName, remoteId);
        return Response.noContent().build();
    }

    @POST
    @Path(value="settings")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Saves gamification connector settings", description="Saves gamification connector settings", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response saveConnectorSettings(@Parameter(description="Remote connector name", required=true) @FormParam(value="connectorName") String connectorName, @Parameter(description="Remote connector Api key", required=true) @FormParam(value="apiKey") String apiKey, @Parameter(description="Remote connector secret key", required=true) @FormParam(value="secretKey") String secretKey, @Parameter(description="Remote connector redirect Url", required=true) @FormParam(value="redirectUrl") String redirectUrl, @Parameter(description="Remote connector status", required=true) @FormParam(value="enabled") @DefaultValue(value="true") boolean enabled) {
        if (StringUtils.isBlank((CharSequence)connectorName)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'connectorName' parameter is mandatory").build();
        }
        Identity identity = ConversationState.getCurrent().getIdentity();
        try {
            RemoteConnectorSettings remoteConnectorSettings = new RemoteConnectorSettings();
            remoteConnectorSettings.setName(connectorName);
            remoteConnectorSettings.setApiKey(apiKey);
            remoteConnectorSettings.setSecretKey(secretKey);
            remoteConnectorSettings.setRedirectUrl(redirectUrl);
            remoteConnectorSettings.setEnabled(enabled);
            this.connectorSettingService.saveConnectorSettings(remoteConnectorSettings, identity);
            return Response.noContent().build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).type("text/plain").build();
        }
        catch (Exception e) {
            LOG.warn("Error saving connector '{}' settings", new Object[]{connectorName, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @DELETE
    @Path(value="settings/{connectorName}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Deletes gamification connector settings", description="Deletes gamification connector settings", method="DELETE")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response deleteConnectorSettings(@Parameter(description="Remote connector name", required=true) @PathParam(value="connectorName") String connectorName) {
        if (StringUtils.isBlank((CharSequence)connectorName)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'connectorName' parameter is mandatory").build();
        }
        Identity identity = ConversationState.getCurrent().getIdentity();
        try {
            this.connectorSettingService.deleteConnectorSettings(connectorName, identity);
            return Response.noContent().build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).type("text/plain").build();
        }
        catch (Exception e) {
            LOG.warn("Error deleting '{}' connector settings", new Object[]{connectorName, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    private List<ConnectorRestEntity> getConnectorsRestEntities(List<String> expandFields, String username) {
        Collection<RemoteConnector> connectorList = this.connectorService.getConnectors(username);
        return ConnectorBuilder.toRestEntities(this.connectorService, this.connectorSettingService, connectorList, expandFields, username);
    }
}

