/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.rest;

import io.meeds.gamification.model.Trigger;
import io.meeds.gamification.rest.builder.TriggerBuilder;
import io.meeds.gamification.rest.model.TriggerRestEntity;
import io.meeds.gamification.service.EventRegistry;
import io.meeds.gamification.service.TriggerService;
import io.meeds.gamification.utils.Utils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/gamification/triggers")
public class TriggerRest
implements ResourceContainer {
    private final EventRegistry eventRegistry;
    private final TriggerService triggerService;

    public TriggerRest(EventRegistry eventRegistry, TriggerService triggerService) {
        this.eventRegistry = eventRegistry;
        this.triggerService = triggerService;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Retrieves the list of gamification triggers", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public Response getTriggers(@Parameter(description="Used to filter triggers by Connector type") @QueryParam(value="type") String type, @Parameter(description="Used to retrieve extra information about triggers") @QueryParam(value="expand") String expand) {
        List<String> expandFields = Utils.getExpandOptions(expand);
        return Response.ok(this.getTriggersRestEntities(expandFields, type)).build();
    }

    @Path(value="status")
    @POST
    @RolesAllowed(value={"users"})
    @Operation(summary="enables/disables trigger for connector account.", description="enables/disables event for connector account", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updateAccountTriggerStatus(@Parameter(description="Trigger name", required=true) @FormParam(value="trigger") String trigger, @Parameter(description="Account Id", required=true) @FormParam(value="accountId") long accountId, @Parameter(description="Trigger status enabled/disabled. possible values: true for enabled, else false", required=true) @FormParam(value="enabled") boolean enabled) {
        String currentUser = Utils.getCurrentUser();
        try {
            this.triggerService.setTriggerEnabledForAccount(trigger, accountId, enabled, currentUser);
            return Response.noContent().build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).type("text/plain").build();
        }
    }

    private List<TriggerRestEntity> getTriggersRestEntities(List<String> expandFields, String type) {
        List<Trigger> triggerList = this.eventRegistry.getTriggers(type);
        return TriggerBuilder.toRestEntities(this.triggerService, triggerList, expandFields);
    }
}

