/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.evm.gamification.service;

import io.meeds.evm.gamification.model.EvmTrigger;
import io.meeds.evm.gamification.service.EvmTriggerService$AjcClosure1;
import io.meeds.gamification.service.EventService;
import io.meeds.gamification.utils.Utils;
import io.meeds.wallet.model.Wallet;
import io.meeds.wallet.service.WalletAccountService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class EvmTriggerService {
    private static final Log LOG;
    public static final String GAMIFICATION_GENERIC_EVENT = "exo.gamification.generic.action";
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private ListenerService listenerService;
    @Autowired
    private EventService eventService;
    @Autowired
    private WalletAccountService walletAccountService;
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    private SpaceService spaceService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public void handleTriggerAsync(EvmTrigger evmTrigger) {
        this.threadPoolTaskExecutor.execute(() -> this.handleTriggerAsyncInternal(evmTrigger));
    }

    @ExoTransactional
    public void handleTriggerAsyncInternal(EvmTrigger evmTrigger) {
        EvmTrigger evmTrigger2 = evmTrigger;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)evmTrigger2);
        Object[] objectArray = new Object[]{this, evmTrigger2, joinPoint};
        EvmTriggerService$AjcClosure1 evmTriggerService$AjcClosure1 = new EvmTriggerService$AjcClosure1(objectArray);
        ExoTransactionalAspect.aspectOf().around(evmTriggerService$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private void processEvent(EvmTrigger evmTrigger) {
        Identity socialIdentity;
        Wallet wallet = this.walletAccountService.getWalletByAddress(evmTrigger.getWalletAddress());
        String receiverId = wallet.getId();
        if (StringUtils.isNotBlank((CharSequence)receiverId) && (socialIdentity = this.identityManager.getOrCreateUserIdentity(receiverId)) != null) {
            String eventDetails = "{contractAddress: " + evmTrigger.getContractAddress() + ", blockchainNetwork: " + evmTrigger.getBlockchainNetwork() + ", targetAddress: " + evmTrigger.getTargetAddress() + ", minAmount: " + String.valueOf(evmTrigger.getAmount()) + ", sentDate: " + evmTrigger.getSentDate() + ", tokenBalance: " + String.valueOf(evmTrigger.getTokenBalance()) + ", duration: " + evmTrigger.getDuration() + "}";
            this.broadcastEvmEvent(evmTrigger.getTrigger(), receiverId, evmTrigger.getNetworkId() + "#" + evmTrigger.getTransactionHash(), evmTrigger.getType(), eventDetails, evmTrigger.getTransactionHash());
        }
    }

    private void broadcastEvmEvent(String ruleTitle, String receiverId, String objectId, String objectType, String eventDetails, String txHash) {
        try {
            List events = this.eventService.getEventsByTitle(ruleTitle, 0, -1);
            if (CollectionUtils.isNotEmpty((Collection)events)) {
                HashMap<String, String> gam = new HashMap<String, String>();
                gam.put("senderId", receiverId);
                gam.put("receiverId", receiverId);
                gam.put("objectId", objectId);
                gam.put("objectType", objectType);
                gam.put("ruleTitle", ruleTitle);
                gam.put("eventDetails", eventDetails);
                this.listenerService.broadcast(GAMIFICATION_GENERIC_EVENT, gam, (Object)"");
                LOG.info("Evm action {} broadcasted for user {} on transaction with hash {}", new Object[]{ruleTitle, receiverId, txHash});
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot broadcast evm gamification event", (Throwable)e);
        }
    }

    public List<String> getWalletAddresses(Long spaceId) {
        if (spaceId == 0L) {
            Set wallets = this.walletAccountService.listWallets();
            return wallets.stream().map(Wallet::getAddress).collect(Collectors.toList());
        }
        ArrayList<String> walletAddresses = new ArrayList<String>();
        Space space = this.spaceService.getSpaceById(String.valueOf(spaceId));
        String[] members = space.getMembers();
        Arrays.stream(members).forEach(member -> {
            Wallet wallet = this.walletAccountService.getWalletByIdentityId(Long.parseLong(Utils.getUserIdentity((String)member).getId()));
            if (wallet != null && wallet.getAddress() != null) {
                walletAddresses.add(wallet.getAddress());
            }
        });
        return walletAddresses;
    }

    static {
        EvmTriggerService.ajc$preClinit();
        LOG = ExoLogger.getLogger(EvmTriggerService.class);
    }

    static final /* synthetic */ void handleTriggerAsyncInternal_aroundBody0(EvmTriggerService ajc$this, EvmTrigger evmTrigger, JoinPoint joinPoint) {
        ajc$this.processEvent(evmTrigger);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("EvmTriggerService.java", EvmTriggerService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "handleTriggerAsyncInternal", "io.meeds.evm.gamification.service.EvmTriggerService", "io.meeds.evm.gamification.model.EvmTrigger", "evmTrigger", "", "void"), 81);
    }
}

