/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.user;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ExpressionUtil;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationServiceException;
import org.exoplatform.portal.mop.navigation.NodeChangeListener;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNavigationComparator;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserNodeContext;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserNodeListener;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.mop.user.UserPortalException;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.resources.LocaleContextInfo;
import org.exoplatform.services.resources.ResourceBundleManager;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;

public class UserPortalImpl
implements UserPortal {
    public static final String SPACES_SITE_TYPE_PREFIX = "/spaces/";
    protected static UserPortalConfigService portalConfigService;
    protected static LayoutService layoutService;
    protected static ResourceBundleManager resourceBundleManager;
    protected static OrganizationService organizationService;
    private final UserNavigationComparator userNavigationComparator = new UserNavigationComparator();
    private final PortalConfig portalConfig;
    private final String userName;
    private List<UserNavigation> navigations;
    private boolean refreshList;
    private final String portalName;
    private final Locale userLocale;

    public UserPortalImpl(String portalName, PortalConfig portal, String userName, Locale locale) {
        this.portalName = portalName;
        this.portalConfig = portal;
        this.userName = userName;
        this.navigations = null;
        this.userLocale = locale;
        if (portalConfigService == null) {
            portalConfigService = (UserPortalConfigService)ExoContainerContext.getService(UserPortalConfigService.class);
            layoutService = (LayoutService)ExoContainerContext.getService(LayoutService.class);
            resourceBundleManager = (ResourceBundleManager)ExoContainerContext.getService(ResourceBundleManager.class);
            organizationService = (OrganizationService)ExoContainerContext.getService(OrganizationService.class);
        }
        this.userNavigationComparator.setGlobalPortal(portalConfigService.getGlobalPortal());
    }

    @Override
    public Locale getLocale() {
        return this.userLocale;
    }

    @Override
    public List<UserNavigation> getNavigations() {
        if (this.navigations == null || this.refreshList) {
            this.loadUserNavigation(new SiteKey(SiteType.PORTAL, this.portalName));
            if (StringUtils.isNotBlank((CharSequence)this.userName)) {
                Identity userIdentity = portalConfigService.getUserACL().getUserIdentity(this.userName);
                List<String> userGroupIds = this.getUserGroupIds(userIdentity);
                if (CollectionUtils.isNotEmpty(userGroupIds)) {
                    userGroupIds.forEach(groupId -> this.loadUserNavigation(SiteKey.group((String)groupId)));
                }
                if (this.refreshList) {
                    this.refreshList = false;
                    this.navigations.removeIf(nav -> {
                        PortalConfig site = layoutService.getPortalConfig(nav.getKey());
                        return site == null || !portalConfigService.getUserACL().hasAccessPermission(site, userIdentity);
                    });
                }
            }
        }
        return Collections.unmodifiableList(this.navigations);
    }

    @Override
    public Collection<UserNode> getNodes(SiteType siteType, Scope scope, UserNodeFilterConfig filterConfig) {
        return this.getNodes(siteType, scope, filterConfig, true);
    }

    @Override
    public Collection<UserNode> getNodes(SiteType siteType, Scope scope, UserNodeFilterConfig filterConfig, boolean includeGlobal) {
        ArrayList<UserNode> resultUserNodes = new ArrayList<UserNode>();
        HashSet<String> addedUserNodesURI = new HashSet<String>();
        for (UserNavigation userNavigation : this.getNavigations()) {
            SiteKey siteKey = userNavigation.getKey();
            if (siteKey.getType() != siteType || siteType == SiteType.GROUP && siteKey.getName().startsWith(SPACES_SITE_TYPE_PREFIX) || siteType == SiteType.SPACE && !siteKey.getName().startsWith(SPACES_SITE_TYPE_PREFIX) || !includeGlobal && siteKey.getName().equalsIgnoreCase(portalConfigService.getGlobalPortal())) continue;
            UserNode rootNode = this.getNode(userNavigation, scope, filterConfig, null);
            Collection<UserNode> userNodes = rootNode.getChildren();
            for (UserNode userNode : userNodes) {
                if (addedUserNodesURI.contains(userNode.getURI())) continue;
                addedUserNodesURI.add(userNode.getURI());
                resultUserNodes.add(userNode);
            }
        }
        return resultUserNodes;
    }

    @Override
    public UserNavigation getNavigation(SiteKey key) {
        if (key == null) {
            throw new IllegalArgumentException("SiteKey is mandatory");
        }
        return this.filterUserNavigation(key);
    }

    @Override
    public void refresh() {
        this.refreshList = true;
    }

    @Override
    public UserNode getNode(UserNavigation userNavigation, Scope scope, UserNodeFilterConfig filterConfig, NodeChangeListener<UserNode> listener) throws NullPointerException, UserPortalException, NavigationServiceException {
        if (userNavigation == null || userNavigation.navigation == null) {
            return null;
        }
        UserNodeContext userNodeContext = new UserNodeContext(userNavigation, filterConfig);
        NodeContext nodeContext = portalConfigService.getNavigationService().loadNode((NodeModel)userNodeContext, userNavigation.navigation, scope, (NodeChangeListener)new UserNodeListener(listener));
        if (nodeContext != null) {
            return ((UserNode)nodeContext.getNode()).filter();
        }
        return null;
    }

    @Override
    public UserNode getNodeById(String userNodeId, SiteKey siteKey, Scope scope, UserNodeFilterConfig filterConfig, NodeChangeListener<UserNode> listener) {
        UserNavigation userNavigation = this.getNavigation(siteKey);
        UserNodeContext userNodeContext = new UserNodeContext(userNavigation, filterConfig);
        NodeContext nodeContext = portalConfigService.getNavigationService().loadNodeById((NodeModel)userNodeContext, userNodeId, scope, (NodeChangeListener)new UserNodeListener(listener));
        if (nodeContext != null) {
            return ((UserNode)nodeContext.getNode()).filter();
        }
        return null;
    }

    @Override
    public void updateNode(UserNode node, Scope scope, NodeChangeListener<UserNode> listener) {
        if (node == null) {
            throw new IllegalArgumentException("UserNode is mandatory");
        }
        portalConfigService.getNavigationService().updateNode(node.context, scope, (NodeChangeListener)new UserNodeListener(listener));
        node.filter();
    }

    @Override
    public void rebaseNode(UserNode node, Scope scope, NodeChangeListener<UserNode> listener) {
        if (node == null) {
            throw new IllegalArgumentException("No null node accepted");
        }
        portalConfigService.getNavigationService().rebaseNode(node.context, scope, (NodeChangeListener)new UserNodeListener(listener));
        node.filter();
    }

    @Override
    public void saveNode(UserNode node, NodeChangeListener<UserNode> listener) throws NullPointerException, UserPortalException, NavigationServiceException {
        if (node == null) {
            throw new IllegalArgumentException("No null node accepted");
        }
        portalConfigService.getNavigationService().saveNode(node.context, (NodeChangeListener)new UserNodeListener(listener));
        this.navigations = null;
        node.filter();
    }

    @Override
    public String getPortalLabel(SiteKey siteKey) {
        return this.getPortalLabel(siteKey, this.userLocale);
    }

    @Override
    public String getPortalLabel(SiteKey siteKey, Locale locale) {
        Group siteGroup;
        String label;
        PortalConfig site = portalConfigService.getDataStorage().getPortalConfig(siteKey);
        String string = label = site == null ? siteKey.getName() : (String)StringUtils.firstNonBlank((CharSequence[])new String[]{site.getLabel(), site.getName(), siteKey.getName()});
        if (siteKey.getType() == SiteType.PORTAL) {
            return (String)StringUtils.firstNonBlank((CharSequence[])new String[]{this.getLabel(siteKey, label, locale), siteKey.getName()});
        }
        if (siteKey.getType() == SiteType.GROUP && (siteGroup = organizationService.getGroupHandler().findGroupById(siteKey.getName())) != null) {
            return siteGroup.getLabel();
        }
        return label;
    }

    @Override
    public String getPortalDescription(SiteKey siteKey) {
        return this.getPortalDescription(siteKey, this.userLocale);
    }

    @Override
    public String getPortalDescription(SiteKey siteKey, Locale locale) {
        Group siteGroup;
        String description;
        PortalConfig site = portalConfigService.getDataStorage().getPortalConfig(siteKey);
        String string = description = site == null ? null : site.getDescription();
        if (siteKey.getType() == SiteType.PORTAL && description != null) {
            return this.getLabel(siteKey, description, locale);
        }
        if (siteKey.getType() == SiteType.GROUP && (siteGroup = organizationService.getGroupHandler().findGroupById(siteKey.getName())) != null) {
            return siteGroup.getLabel();
        }
        return description;
    }

    public PortalConfig getPortalConfig() {
        return this.portalConfig;
    }

    protected String getLabel(SiteKey siteKey, String label, Locale locale) {
        if (ExpressionUtil.isResourceBindingExpression((String)label)) {
            return Stream.of(locale, ResourceBundleService.DEFAULT_CROWDIN_LOCALE).map(l -> this.getBundle(siteKey.getTypeName(), siteKey.getName(), locale)).filter(Objects::nonNull).map(b -> ExpressionUtil.getExpressionValue((ResourceBundle)b, (String)label)).filter(StringUtils::isNotBlank).findFirst().orElse(null);
        }
        return label;
    }

    protected UserNavigation filterUserNavigation(SiteKey key) {
        UserNavigation userNavigation;
        UserNavigation userNavigation2 = userNavigation = this.navigations == null ? null : (UserNavigation)this.navigations.stream().filter(nav -> nav.getKey().equals((Object)key)).findFirst().orElse(null);
        if (userNavigation == null) {
            this.refreshList = true;
            return this.loadUserNavigation(key);
        }
        return userNavigation;
    }

    protected UserNavigation loadUserNavigation(SiteKey siteKey) {
        if (this.navigations == null) {
            this.navigations = new ArrayList<UserNavigation>();
            if (siteKey.getType() == SiteType.PORTAL && StringUtils.isNotBlank((CharSequence)portalConfigService.getGlobalPortal()) && !StringUtils.equals((CharSequence)portalConfigService.getGlobalPortal(), (CharSequence)siteKey.getName())) {
                this.loadUserNavigation(new SiteKey(SiteType.PORTAL, portalConfigService.getGlobalPortal()));
            }
        } else {
            this.navigations.removeIf(nav -> nav.getKey().equals((Object)siteKey));
        }
        NavigationContext navigationContext = portalConfigService.getNavigationService().loadNavigation(siteKey);
        PortalConfig sitePortalConfig = portalConfigService.getDataStorage().getPortalConfig(siteKey);
        UserACL userAcl = portalConfigService.getUserACL();
        if (navigationContext != null && navigationContext.getState() != null && userAcl.hasAccessPermission(sitePortalConfig, userAcl.getUserIdentity(this.userName))) {
            UserNavigation userNavigation = new UserNavigation(this, navigationContext, userAcl.hasEditPermission(sitePortalConfig, userAcl.getUserIdentity(this.userName)));
            this.navigations.add(userNavigation);
            Collections.sort(this.navigations, this.userNavigationComparator);
            return userNavigation;
        }
        return null;
    }

    protected List<String> getUserGroupIds(Identity identity) {
        Set groups = null;
        if (StringUtils.isBlank((CharSequence)this.userName) || IdentityConstants.ANONIM.equals(this.userName) || IdentityConstants.SYSTEM.equals(this.userName) || identity == null) {
            return Collections.emptyList();
        }
        groups = identity.getGroups();
        return this.getUserGroupIds(groups);
    }

    private List<String> getUserGroupIds(Collection<?> groups) {
        String guestsGroupId = portalConfigService.getUserACL().getGuestsGroup();
        return groups.stream().map(groupObj -> {
            if (groupObj instanceof Group) {
                Group group = (Group)groupObj;
                return group.getId().trim();
            }
            return groupObj.toString().trim();
        }).filter(groupId -> !StringUtils.equals((CharSequence)groupId, (CharSequence)guestsGroupId)).toList();
    }

    public ResourceBundle getBundle(UserNavigation navigation) {
        return this.getBundle(this.getSiteType(navigation), this.getSiteName(navigation), this.userLocale);
    }

    private ResourceBundle getBundle(String siteType, String siteName, Locale locale) {
        return resourceBundleManager.getNavigationResourceBundle(LocaleContextInfo.getLocaleAsString((Locale)locale), siteType, siteName);
    }

    private String getSiteName(UserNavigation navigation) {
        return navigation.getKey().getName();
    }

    private String getSiteType(UserNavigation navigation) {
        return navigation.getKey().getTypeName();
    }

    @Override
    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public Locale getUserLocale() {
        return this.userLocale;
    }
}

