/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.reward.scheduling.task;

import io.meeds.common.ContainerTransactional;
import io.meeds.common.ContainerTransactionalAspect;
import io.meeds.wallet.model.RewardPeriod;
import io.meeds.wallet.model.RewardReport;
import io.meeds.wallet.model.Wallet;
import io.meeds.wallet.reward.scheduling.task.RewardStatusVerifierTask$AjcClosure1;
import io.meeds.wallet.reward.service.RewardReportService;
import io.meeds.wallet.service.WalletAccountService;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.services.listener.ListenerService;
import org.quartz.DisallowConcurrentExecution;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@DisallowConcurrentExecution
@Component
public class RewardStatusVerifierTask {
    @Autowired
    private RewardReportService rewardReportService;
    @Autowired
    private WalletAccountService walletAccountService;
    @Autowired
    private ListenerService listenerService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @ContainerTransactional
    @Scheduled(cron="${exo.wallet.RewardStatusVerifierJob.expression:0 * * * * ?}")
    public void execute() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        RewardStatusVerifierTask$AjcClosure1 rewardStatusVerifierTask$AjcClosure1 = new RewardStatusVerifierTask$AjcClosure1(objectArray);
        ContainerTransactionalAspect.aspectOf().around(rewardStatusVerifierTask$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    static {
        RewardStatusVerifierTask.ajc$preClinit();
    }

    static final /* synthetic */ void execute_aroundBody0(RewardStatusVerifierTask ajc$this, JoinPoint joinPoint) {
        Wallet adminWallet = ajc$this.walletAccountService.getAdminWallet();
        if (!ajc$this.walletAccountService.isAdminAccountEnabled() || adminWallet == null || adminWallet.getEtherBalance() == null || adminWallet.getEtherBalance() == 0.0 || adminWallet.getTokenBalance() == null || adminWallet.getTokenBalance() == 0.0) {
            return;
        }
        List rewardPeriodsInProgress = ajc$this.rewardReportService.getRewardPeriodsInProgress();
        if (rewardPeriodsInProgress != null && !rewardPeriodsInProgress.isEmpty()) {
            for (RewardPeriod rewardPeriod : rewardPeriodsInProgress) {
                RewardReport rewardReport;
                if (ajc$this.rewardReportService.isRewardSendingInProgress() || (rewardReport = ajc$this.rewardReportService.computeRewards(rewardPeriod.getPeriodMedianDate())) == null) continue;
                if (rewardReport.isCompletelyProcessed()) {
                    ajc$this.listenerService.broadcast("exo.wallet.reward.report.success", (Object)rewardReport, null);
                    ajc$this.rewardReportService.saveRewardReport(rewardReport);
                    continue;
                }
                if (rewardReport.getPendingTransactionCount() != 0L || rewardReport.getTokensSent() != 0.0) continue;
                ajc$this.rewardReportService.saveRewardReport(rewardReport);
            }
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("RewardStatusVerifierTask.java", RewardStatusVerifierTask.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "execute", "io.meeds.wallet.reward.scheduling.task.RewardStatusVerifierTask", "", "", "", "void"), 60);
    }
}

