/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.service.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.exoplatform.social.common.service.ProcessContext;
import org.exoplatform.social.common.service.SocialServiceContext;
import org.exoplatform.social.common.service.utils.ObjectHelper;
import org.exoplatform.social.common.service.utils.TraceElement;

public class ProcessorContextImpl
implements ProcessContext {
    protected final SocialServiceContext context;
    private Map<String, Object> properties;
    private Exception exception;
    private boolean isDone;
    private StringBuffer tracer;
    private TraceElement traceElement;
    private String name;
    private Object lock = new Object();
    private AtomicInteger currentProcesses = new AtomicInteger(0);

    public ProcessorContextImpl(SocialServiceContext context) {
        this("DefaultProcessor", context);
    }

    public ProcessorContextImpl(String name, SocialServiceContext context) {
        this.context = context;
        this.tracer = new StringBuffer();
        this.name = name;
    }

    public ProcessorContextImpl(ProcessContext parent) {
        this(parent.getContext());
    }

    public String toString() {
        return "ProcessorContext[Default]";
    }

    @Override
    public Object getProperty(String name) {
        if (this.properties != null) {
            return this.properties.get(name);
        }
        return null;
    }

    @Override
    public Object getProperty(String name, Object defaultValue) {
        Object got = this.getProperty(name);
        return got != null ? got : defaultValue;
    }

    @Override
    public <T> T getProperty(String name, Class<T> type) {
        Object value = this.getProperty(name);
        if (value == null) {
            if (Boolean.TYPE.isAssignableFrom(type)) {
                return (T)Boolean.FALSE;
            }
            if (Integer.TYPE.isAssignableFrom(type)) {
                return (T)new Integer(-1);
            }
            return null;
        }
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        return (T)value;
    }

    @Override
    public <T> T getProperty(String name, Object defaultValue, Class<T> type) {
        Object value = this.getProperty(name, defaultValue);
        if (value == null) {
            if (Boolean.TYPE.isAssignableFrom(type)) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        return (T)value;
    }

    @Override
    public void setProperty(String name, Object value) {
        if (value != null) {
            this.getProperties().put(name, value);
        } else if (name != null) {
            this.getProperties().remove(name);
        }
    }

    @Override
    public Object removeProperty(String name) {
        if (!this.hasProperties()) {
            return null;
        }
        return this.getProperties().remove(name);
    }

    @Override
    public Map<String, Object> getProperties() {
        if (this.properties == null) {
            this.properties = new ConcurrentHashMap<String, Object>();
        }
        return this.properties;
    }

    @Override
    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    @Override
    public <T> T getException(Class<T> type) {
        return ObjectHelper.getException(type, this.exception);
    }

    @Override
    public void setException(Throwable t) {
        this.exception = t == null ? null : (t instanceof Exception ? (Exception)t : new Exception("Exception occurred during execution", t));
    }

    @Override
    public boolean isFailed() {
        return this.getException() != null;
    }

    @Override
    public ProcessContext copy() {
        return null;
    }

    @Override
    public String getProcessorCompletion() {
        return null;
    }

    @Override
    public void setProcessorName(String name) {
    }

    @Override
    public SocialServiceContext getContext() {
        return this.context;
    }

    private static Map<String, Object> safeCopy(Map<String, Object> properties) {
        if (properties == null) {
            return null;
        }
        return new ConcurrentHashMap<String, Object>(properties);
    }

    @Override
    public boolean isInProgress() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    @Override
    public void done(boolean isDone) {
        this.isDone = isDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void trace(String processorName, String trace) {
        Object object = this.lock;
        synchronized (object) {
            this.tracer.append(String.format("%s::%s-", processorName, trace));
        }
    }

    @Override
    public String getTraceLog() {
        return new StringBuffer().append(this.tracer.toString()).append(this.getTraceElement().toString()).toString();
    }

    @Override
    public StringBuffer getTracer() {
        return this.tracer;
    }

    @Override
    public TraceElement getTraceElement() {
        if (this.traceElement == null) {
            this.traceElement = TraceElement.getInstance(this.name);
        }
        return this.traceElement;
    }

    @Override
    public void setTraceElement(TraceElement traceElement) {
        this.traceElement = traceElement;
    }

    @Override
    public void totalProcesses(int total) {
        this.currentProcesses.set(total);
    }

    @Override
    public int getTotalProcesses() {
        return this.currentProcesses.get();
    }
}

