/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.web.filter.Filter;

public class WikiToNotesRedirectFilter
implements Filter {
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        String reqUri = httpServletRequest.getRequestURI();
        boolean isRestUri = reqUri.contains(ExoContainerContext.getCurrentContainer().getContext().getRestContextName());
        if (!isRestUri) {
            List<String> resList = Arrays.asList(reqUri.split("/"));
            int i = resList.indexOf("wiki");
            int j = resList.indexOf("WikiPortlet");
            if (i > 0 || j > 0) {
                if (i > 0) {
                    resList.set(i, "notes");
                }
                if (j > 0) {
                    resList.set(j, "notes");
                }
                reqUri = String.join((CharSequence)"/", resList);
                httpServletResponse.sendRedirect(reqUri);
                return;
            }
        }
        chain.doFilter(request, response);
    }
}

