/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.portlet;

import io.meeds.social.cms.service.CMSService;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.StampedLock;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.api.portlet.GenericDispatchedViewPortlet;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.pom.spi.portlet.Portlet;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.webui.Utils;

public class CMSPortlet
extends GenericDispatchedViewPortlet {
    public static final String DATA_INIT_PREFERENCE_NAME = "data.init";
    public static final String NAME = "name";
    private static final String PREFIX_UNTITLED_NAME = "Untitled";
    private static final StampedLock LOCK = new StampedLock();
    private static final Map<String, Boolean> INITIALIZED = new ConcurrentHashMap<String, Boolean>();
    private static final Log LOG = ExoLogger.getLogger(CMSPortlet.class);
    protected String contentType;
    private CMSService cmsService;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.contentType = config.getInitParameter("content-type");
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        String name = this.getOrCreateSettingName(request.getPreferences());
        request.setAttribute("canEdit", (Object)this.canEdit(name, this.getCurrentAclIdentity()));
        request.setAttribute("settingName", (Object)name);
        this.setViewRequestAttributes(name, request, response);
        super.doView(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveSettingName(String name, String pageReference, long spaceId) {
        String identityId = Utils.getViewerIdentityId();
        long stamp = -1L;
        try {
            stamp = LOCK.tryWriteLock(2L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOG.debug((Object)"Unable to acquire lock before saving setting", (Throwable)e);
        }
        try {
            if (identityId == null) {
                identityId = this.getSuperUserIdentityId();
            }
            this.getCmsService().saveSettingName(this.contentType, name, pageReference, spaceId, identityId == null ? 0L : Long.parseLong(identityId));
        }
        catch (ObjectAlreadyExistsException e) {
            LOG.debug("CMS Setting {}/{} already exists", new Object[]{this.contentType, name, e});
        }
        finally {
            INITIALIZED.remove(name);
            if (stamp >= 0L) {
                LOCK.unlock(stamp);
            }
        }
    }

    protected boolean isSettingNameExists(String name) {
        return this.getCmsService().isSettingNameExists(this.contentType, name);
    }

    protected boolean canEdit(String name, Identity userAclIdentity) {
        return this.getCmsService().hasEditPermission(this.getCurrentAclIdentity(), this.contentType, name);
    }

    protected void setViewRequestAttributes(String name, RenderRequest request, RenderResponse response) {
    }

    protected void preSettingInit(PortletPreferences preferences, String name) {
    }

    protected void postSettingInit(PortletPreferences preferences, String name) {
    }

    protected void savePreference(String name, String value) {
        String storageId = UIPortlet.getCurrentUIPortlet().getStorageId();
        LayoutService layoutService = (LayoutService)ExoContainerContext.getService(LayoutService.class);
        Application applicationModel = layoutService.getApplicationModel(storageId);
        ApplicationState state = applicationModel.getState();
        Portlet prefs = layoutService.load(state);
        prefs.setValue(name, value);
        layoutService.save(state, prefs);
    }

    protected String generateRandomId() {
        String name;
        String storageId;
        String string = storageId = UIPortlet.getCurrentUIPortlet() == null ? "" : UIPortlet.getCurrentUIPortlet().getStorageId();
        while (this.isSettingNameExists(name = "Untitled-" + storageId + "-" + UUID.randomUUID().toString())) {
        }
        return name;
    }

    private String getOrCreateSettingName(PortletPreferences preferences) {
        String name = preferences.getValue(NAME, null);
        if (!this.isInitialized(name)) {
            if (name == null) {
                name = this.generateRandomId();
                this.savePreference(NAME, name);
            }
            this.preSettingInit(preferences, name);
            String pageReference = this.getCurrentPageReference();
            if (StringUtils.contains((CharSequence)pageReference, (CharSequence)"_draft_")) {
                pageReference = pageReference.split("_draft_")[0];
            }
            this.saveSettingName(name, pageReference, this.getCurrentSpaceId());
            this.postSettingInit(preferences, name);
        }
        return name;
    }

    private boolean isInitialized(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return false;
        }
        return INITIALIZED.computeIfAbsent(name, this::isSettingNameExists);
    }

    private CMSService getCmsService() {
        if (this.cmsService == null) {
            this.cmsService = (CMSService)ExoContainerContext.getService(CMSService.class);
        }
        return this.cmsService;
    }

    private String getSuperUserIdentityId() {
        UserACL userAcl = (UserACL)ExoContainerContext.getService(UserACL.class);
        IdentityManager identityManager = (IdentityManager)ExoContainerContext.getService(IdentityManager.class);
        String superUser = userAcl.getSuperUser();
        return identityManager.getOrCreateUserIdentity(superUser).getId();
    }

    private Identity getCurrentAclIdentity() {
        ConversationState conversationState = ConversationState.getCurrent();
        return conversationState == null ? null : conversationState.getIdentity();
    }

    private String getCurrentPageReference() {
        return Util.getUIPage().getPageId();
    }

    private long getCurrentSpaceId() {
        Space space = SpaceUtils.getSpaceByContext();
        String spaceId = space == null ? null : space.getId();
        return spaceId == null ? 0L : Long.parseLong(spaceId);
    }
}

