/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui;

import java.util.Arrays;
import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.RequestNavigationData;
import org.exoplatform.social.common.router.ExoRouter;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.web.application.RequestContext;

public class URLUtils {
    public static String getCurrentUser() {
        IdentityManager identityManager;
        Identity identity;
        PortalRequestContext pcontext = URLUtils.getPortalRequestContext();
        String requestPath = "/" + pcontext.getControllerContext().getParameter(RequestNavigationData.REQUEST_PATH);
        ExoRouter.Route route = ExoRouter.route((String)requestPath);
        if (route == null) {
            return null;
        }
        String currentUserName = (String)route.localArgs.get("streamOwnerId");
        Identity viewerIdentity = Utils.getViewerIdentity();
        if (viewerIdentity.isExternal() && !URLUtils.isProfileAccessible(currentUserName, pcontext.getRemoteUser())) {
            return null;
        }
        if (currentUserName != null && (identity = (identityManager = (IdentityManager)ExoContainerContext.getService(IdentityManager.class)).getOrCreateUserIdentity(currentUserName)) != null) {
            return identity.getRemoteId();
        }
        return null;
    }

    private static boolean isProfileAccessible(String currentUserName, String externalUserId) {
        try {
            List<Identity> viewerFriends = Utils.getViewerFriends();
            boolean isFriend = viewerFriends.stream().anyMatch(value -> value.getRemoteId().equals(currentUserName));
            SpaceService spaceService = (SpaceService)ExoContainerContext.getService(SpaceService.class);
            ListAccess memberSpacesListAccess = spaceService.getMemberSpaces(externalUserId);
            Space[] spaces = (Space[])memberSpacesListAccess.load(0, memberSpacesListAccess.getSize());
            boolean isMemberSpaces = Arrays.stream(spaces).anyMatch(space -> Utils.getSpaceService().isMember(space, currentUserName));
            return isFriend || isMemberSpaces;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error checking whether profile " + currentUserName + " is accessible for " + externalUserId + " or not", e);
        }
    }

    private static PortalRequestContext getPortalRequestContext() {
        RequestContext context = RequestContext.getCurrentInstance();
        if (context != null && !(context instanceof PortalRequestContext)) {
            context = context.getParentAppRequestContext();
        }
        return (PortalRequestContext)context;
    }
}

