/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.exoplatform.container.AbstractInterceptor;
import org.exoplatform.container.spi.ComponentAdapter;
import org.exoplatform.container.spi.Container;
import org.exoplatform.container.spi.ContainerException;
import org.exoplatform.container.spi.ContainerVisitor;

public class CachingContainer
extends AbstractInterceptor {
    private static final long serialVersionUID = 316388590860241305L;
    private final ConcurrentMap<Class<?>, ComponentAdapter<?>> adapterByType = new ConcurrentHashMap();
    private final ConcurrentMap<Class<?>, Object> instanceByType = new ConcurrentHashMap();
    private final ConcurrentMap<Object, Object> instanceByKey = new ConcurrentHashMap<Object, Object>();
    private final ConcurrentMap<Class<?>, Object> adaptersByType = new ConcurrentHashMap();
    private final ConcurrentMap<Class<?>, List<?>> instancesByType = new ConcurrentHashMap();
    private final ThreadLocal<Boolean> enabled = new ThreadLocal();
    private static final ContainerVisitor invalidator = new ContainerVisitor(){

        @Override
        public void visitContainer(Container container) {
            do {
                if (!(container instanceof CachingContainer)) continue;
                CachingContainer caching = (CachingContainer)container;
                caching.adapterByType.clear();
                caching.adaptersByType.clear();
                caching.instanceByKey.clear();
                caching.instanceByType.clear();
                caching.instancesByType.clear();
                break;
            } while ((container = container.getSuccessor()) != null);
        }
    };

    @Override
    public <T> ComponentAdapter<T> getComponentAdapterOfType(Class<T> componentType, boolean autoRegistration) {
        ComponentAdapter<T> adapter = (ComponentAdapter<T>)this.adapterByType.get(componentType);
        if (adapter == null && (adapter = super.getComponentAdapterOfType(componentType, autoRegistration)) != null) {
            this.adapterByType.put(componentType, adapter);
        }
        return adapter;
    }

    @Override
    public <T> List<ComponentAdapter<T>> getComponentAdaptersOfType(Class<T> componentType) {
        List<ComponentAdapter<T>> adapters = (List<ComponentAdapter<T>>)this.adaptersByType.get(componentType);
        if (adapters == null && (adapters = super.getComponentAdaptersOfType(componentType)) != null) {
            this.adaptersByType.put(componentType, adapters);
        }
        return adapters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> getComponentInstancesOfType(Class<T> componentType) throws ContainerException {
        List<T> instances = (List<T>)this.instancesByType.get(componentType);
        if (instances == null && (instances = super.getComponentInstancesOfType(componentType)) != null) {
            Boolean cacheEnabled = this.enabled.get();
            try {
                if (cacheEnabled == null || cacheEnabled.booleanValue()) {
                    this.instancesByType.put(componentType, instances);
                }
            }
            finally {
                if (cacheEnabled != null) {
                    this.enabled.remove();
                }
            }
        }
        return instances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getComponentInstance(Object componentKey, Class<T> bindType, boolean autoRegistration) throws ContainerException {
        Object instance = this.instanceByKey.get(componentKey);
        if (instance == null && (instance = super.getComponentInstance(componentKey, bindType, autoRegistration)) != null) {
            Boolean cacheEnabled = this.enabled.get();
            try {
                if (cacheEnabled == null || cacheEnabled.booleanValue()) {
                    this.instanceByKey.put(componentKey, instance);
                }
            }
            finally {
                if (cacheEnabled != null) {
                    this.enabled.remove();
                }
            }
        }
        return bindType.cast(instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getComponentInstanceOfType(Class<T> componentType, boolean autoRegistration) {
        Object instance = this.instanceByType.get(componentType);
        if (instance == null && (instance = super.getComponentInstanceOfType(componentType, autoRegistration)) != null) {
            Boolean cacheEnabled = this.enabled.get();
            try {
                if (cacheEnabled == null || cacheEnabled.booleanValue()) {
                    this.instanceByType.put(componentType, instance);
                }
            }
            finally {
                if (cacheEnabled != null) {
                    this.enabled.remove();
                }
            }
        }
        return componentType.cast(instance);
    }

    private void invalidate() {
        this.accept(invalidator);
    }

    @Override
    public ComponentAdapter<?> unregisterComponent(Object componentKey) {
        ComponentAdapter<?> adapter = super.unregisterComponent(componentKey);
        this.invalidate();
        return adapter;
    }

    @Override
    public <T> ComponentAdapter<T> registerComponentInstance(Object componentKey, T componentInstance) throws ContainerException {
        ComponentAdapter<T> adapter = super.registerComponentInstance(componentKey, componentInstance);
        this.invalidate();
        return adapter;
    }

    @Override
    public <T> ComponentAdapter<T> registerComponentImplementation(Object componentKey, Class<T> componentImplementation) throws ContainerException {
        ComponentAdapter<T> adapter = super.registerComponentImplementation(componentKey, componentImplementation);
        this.invalidate();
        return adapter;
    }

    @Override
    public String getId() {
        return "Cache";
    }

    void disable() {
        this.enabled.set(Boolean.FALSE);
    }
}

