/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.kudos.rest;

import io.meeds.kudos.model.AccountSettings;
import io.meeds.kudos.service.KudosService;
import io.meeds.kudos.service.utils.Utils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"account"})
@Tag(name="/kudos/rest/account", description="Retrieve Kudos settings for users and spaces")
public class KudosAccountREST {
    @Autowired
    private KudosService kudosService;

    @GetMapping(value={"settings"})
    @Secured(value={"users"})
    @Operation(summary="Retrieves user/space settings for kudos", method="GET", description="returns account settings object")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public AccountSettings getSettings() {
        AccountSettings accountDetail = this.kudosService.getAccountSettings(Utils.getCurrentUserId());
        if (accountDetail == null) {
            return new AccountSettings();
        }
        return accountDetail;
    }
}

