/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.service.rest.Util;

public final class RestChecker {
    public static void checkAuthenticatedRequest() {
        if (!RestChecker.isAuthenticatedRequest()) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
    }

    public static int checkSupportedVersion(String version) {
        try {
            return SUPPORT_VERSION.valueOf(version).getVersion();
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    public static PortalContainer checkValidPortalContainerName(String portalContainerName) {
        PortalContainer portalContainer = Util.getPortalContainerByName(portalContainerName);
        if (portalContainer == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        return portalContainer;
    }

    public static MediaType checkSupportedFormat(String expectedFormat, String[] supportedFormats) {
        return Util.getMediaType(expectedFormat, supportedFormats);
    }

    private RestChecker() {
    }

    private static boolean isAuthenticatedRequest() {
        return ConversationState.getCurrent() != null && ConversationState.getCurrent().getIdentity() != null && ConversationState.getCurrent().getIdentity().getUserId() != null;
    }

    public static void checkAuthenticatedUserPermission(String targetUser) {
        try {
            String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
            if (!targetUser.equals(authenticatedUser)) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
    }

    public static enum SUPPORT_VERSION {
        v1(1),
        v2(2);

        private int version;

        private SUPPORT_VERSION(int version) {
            this.version = version;
        }

        public int getVersion() {
            return this.version;
        }
    }
}

