/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.resources.impl;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.io.FileUtils;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.MapResourceBundle;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.resources.ExoResourceBundle;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.Query;
import org.exoplatform.services.resources.ResourceBundleData;
import org.exoplatform.services.resources.impl.BaseResourceBundleService;
import org.json.JSONObject;

public class SimpleResourceBundleService
extends BaseResourceBundleService {
    public static final Locale DEFAULT_I18N_LOCALE = Locale.ENGLISH;
    private static final String CACHE_NAME = "portal.ResourceBundleData";
    private static final boolean DEVELOPPING = PropertyManager.isDevelopping();
    private final ConcurrentMap<String, ResourceBundleData> bundles = new ConcurrentHashMap<String, ResourceBundleData>();
    private final ConcurrentMap<Integer, File> files = new ConcurrentHashMap<Integer, File>();

    public SimpleResourceBundleService(PortalContainer portalContainer, InitParams params, CacheService cService, LocaleConfigService localeService) {
        this.portalContainer_ = portalContainer;
        this.localeService_ = localeService;
        this.cache_ = cService.getCacheInstance(CACHE_NAME);
        this.initParams(params);
    }

    public ResourceBundleData getResourceBundleData(String id) {
        return (ResourceBundleData)this.bundles.get(id);
    }

    public ResourceBundleData removeResourceBundleData(String id) {
        if (id == null) {
            return null;
        }
        ResourceBundleData data = (ResourceBundleData)this.bundles.remove(id);
        this.invalidate(id);
        return data;
    }

    public void saveResourceBundle(ResourceBundleData resourceData) {
        String id = resourceData.getId();
        this.bundles.put(id, resourceData);
        this.invalidate(id);
    }

    public PageList<ResourceBundleData> findResourceDescriptions(Query q) {
        final ArrayList<ResourceBundleData> list = new ArrayList<ResourceBundleData>();
        for (ResourceBundleData data : this.bundles.values()) {
            boolean matches = true;
            if (q.getName() != null) {
                matches &= q.getName().equals(data.getName());
            }
            if (q.getLanguage() != null) {
                matches &= q.getLanguage().equals(data.getLanguage());
            }
            if (!matches) continue;
            list.add(data);
        }
        Collections.sort(list, new Comparator<ResourceBundleData>(this){

            @Override
            public int compare(ResourceBundleData o1, ResourceBundleData o2) {
                String l1 = o1.getLanguage();
                String l2 = o2.getLanguage();
                if (l1 == null) {
                    return l2 == null ? 0 : 1;
                }
                return l1.compareTo(l2);
            }
        });
        return new LazyPageList((ListAccess)new ListAccess<ResourceBundleData>(this){

            public ResourceBundleData[] load(int index, int length) throws Exception {
                List sub = list.subList(index, index + length);
                return sub.toArray(new ResourceBundleData[sub.size()]);
            }

            public int getSize() throws Exception {
                return list.size();
            }
        }, 20);
    }

    @Override
    protected ResourceBundle getResourceBundleFromDb(String id, ResourceBundle parent, Locale locale) throws Exception {
        ResourceBundleData data = this.getResourceBundleData(id);
        if (data == null) {
            return null;
        }
        return new MapResourceBundle((ResourceBundle)new ExoResourceBundle(data, parent), locale);
    }

    public String getResourceBundleContent(String resourceBundleName, Locale locale) {
        if (DEVELOPPING) {
            return this.getResourceBundleFileContent(resourceBundleName, locale);
        }
        File bundleFile = this.files.computeIfAbsent((resourceBundleName + locale.toLanguageTag()).hashCode(), k -> {
            String fileContent = this.getResourceBundleFileContent(resourceBundleName, locale);
            if (fileContent != null) {
                return this.writeResourceBundleFileContent(resourceBundleName, locale, fileContent);
            }
            return null;
        });
        if (bundleFile != null) {
            return FileUtils.readFileToString((File)bundleFile, (Charset)StandardCharsets.UTF_8);
        }
        return null;
    }

    private File writeResourceBundleFileContent(String resourceBundleName, Locale locale, String fileContent) {
        try {
            File file = File.createTempFile("i18n_cache_", resourceBundleName + locale.toLanguageTag() + ".json");
            FileUtils.write((File)file, (CharSequence)fileContent, (Charset)StandardCharsets.UTF_8);
            file.deleteOnExit();
            return file;
        }
        catch (Exception e) {
            LOG.error("Error while I18N Bundle {} with lang {}", new Object[]{resourceBundleName, locale, e});
            return null;
        }
    }

    private String getResourceBundleFileContent(String resourceBundleName, Locale locale) {
        ResourceBundle resourceBundle = this.getResourceBundle(resourceBundleName, locale);
        ResourceBundle defaultResourceBundle = this.getResourceBundle(resourceBundleName, DEFAULT_I18N_LOCALE);
        if (resourceBundle == null) {
            resourceBundle = defaultResourceBundle;
        }
        if (resourceBundle != null) {
            String key;
            JSONObject resultJSON = new JSONObject();
            Enumeration<String> keys = resourceBundle.getKeys();
            while (keys.hasMoreElements()) {
                key = keys.nextElement();
                resultJSON.put(key, (Object)resourceBundle.getString(key));
            }
            keys = defaultResourceBundle.getKeys();
            while (keys.hasMoreElements()) {
                key = keys.nextElement();
                if (!resultJSON.isNull(key)) continue;
                resultJSON.put(key, (Object)defaultResourceBundle.getString(key));
            }
            return resultJSON.toString();
        }
        return null;
    }
}

