/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class SparseVectorStats
implements JsonpSerializable {
    private final long valueCount;
    public static final JsonpDeserializer<SparseVectorStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SparseVectorStats::setupSparseVectorStatsDeserializer);

    private SparseVectorStats(Builder builder) {
        this.valueCount = ApiTypeHelper.requireNonNull(builder.valueCount, (Object)this, "valueCount", 0L);
    }

    public static SparseVectorStats of(Function<Builder, ObjectBuilder<SparseVectorStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long valueCount() {
        return this.valueCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("value_count");
        generator.write(this.valueCount);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupSparseVectorStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::valueCount, JsonpDeserializer.longDeserializer(), "value_count");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SparseVectorStats> {
        private Long valueCount;

        public final Builder valueCount(long value) {
            this.valueCount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SparseVectorStats build() {
            this._checkSingleUse();
            return new SparseVectorStats(this);
        }
    }
}

