/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.page;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;

public class UIPageFactory {
    public static final String DEFAULT_FACTORY_ID = "Default";
    protected static Map<String, UIPageFactory> pageFactory = new HashMap<String, UIPageFactory>();

    public static UIPageFactory getInstance(String type) {
        UIPageFactory factory = pageFactory.get(type);
        if (type == null) {
            factory = pageFactory.get(DEFAULT_FACTORY_ID);
        }
        return factory;
    }

    public String getType() {
        return DEFAULT_FACTORY_ID;
    }

    public UIPage createUIPage(WebuiRequestContext context) throws Exception {
        if (context == null) {
            context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        }
        WebuiApplication app = (WebuiApplication)context.getApplication();
        UIPage uiPage = app.createUIComponent(UIPage.class, null, null, context);
        return uiPage;
    }

    static {
        ServiceLoader<UIPageFactory> loader = ServiceLoader.load(UIPageFactory.class);
        for (UIPageFactory factory : loader) {
            pageFactory.put(factory.getType(), factory);
        }
    }
}

