/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.util;

import io.meeds.layout.model.LayoutModel;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collection;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.social.attachment.AttachmentService;
import org.exoplatform.social.attachment.model.ObjectAttachmentDetail;
import org.exoplatform.social.attachment.model.ObjectAttachmentList;
import org.exoplatform.social.attachment.model.UploadedAttachmentDetail;
import org.exoplatform.upload.UploadResource;

public class DatabindUtils {
    private static final Random RANDOM = new Random();

    private DatabindUtils() {
    }

    public static void retrieveBackgroundImages(LayoutModel layout, FileService fileService) {
        String[] parts;
        String lastPart;
        FileItem file;
        String backgroundImage;
        String[] parts2;
        String lastPart2;
        FileItem file2;
        if (layout == null) {
            return;
        }
        String appBackgroundImage = layout.getAppBackgroundImage();
        if (appBackgroundImage != null && !appBackgroundImage.isEmpty() && (file2 = fileService.getFile(Long.parseLong(lastPart2 = (parts2 = appBackgroundImage.split("/"))[parts2.length - 1]))) != null) {
            layout.setAppBackgroundImage(Base64.encodeBase64String((byte[])file2.getAsByte()));
        }
        if ((backgroundImage = layout.getBackgroundImage()) != null && !backgroundImage.isEmpty() && (file = fileService.getFile(Long.parseLong(lastPart = (parts = backgroundImage.split("/"))[parts.length - 1]))) != null) {
            layout.setBackgroundImage(Base64.encodeBase64String((byte[])file.getAsByte()));
        }
        if (layout.getChildren() != null) {
            for (LayoutModel child : layout.getChildren()) {
                DatabindUtils.retrieveBackgroundImages(child, fileService);
            }
        }
    }

    public static void saveAppBackgroundImages(long pageTemplateId, LayoutModel layout, AttachmentService attachmentService, long userIdentityId) {
        ObjectAttachmentDetail attachment;
        String backgroundImage;
        ObjectAttachmentDetail attachment2;
        if (layout == null) {
            return;
        }
        String appBackgroundImage = layout.getAppBackgroundImage();
        if (appBackgroundImage != null && !appBackgroundImage.isEmpty() && (attachment2 = DatabindUtils.saveAppBackgroundImage(pageTemplateId, Base64.decodeBase64((String)appBackgroundImage), attachmentService, userIdentityId)) != null) {
            layout.setAppBackgroundImage(DatabindUtils.buildBackgroundUrl(String.valueOf(pageTemplateId), attachment2));
        }
        if ((backgroundImage = layout.getBackgroundImage()) != null && !backgroundImage.isEmpty() && (attachment = DatabindUtils.saveAppBackgroundImage(pageTemplateId, Base64.decodeBase64((String)backgroundImage), attachmentService, userIdentityId)) != null) {
            layout.setBackgroundImage(DatabindUtils.buildBackgroundUrl(String.valueOf(pageTemplateId), attachment));
        }
        if (layout.getChildren() != null) {
            for (LayoutModel child : layout.getChildren()) {
                DatabindUtils.saveAppBackgroundImages(pageTemplateId, child, attachmentService, userIdentityId);
            }
        }
    }

    public static String buildBackgroundUrl(String objectId, ObjectAttachmentDetail attachment) {
        return String.format("/portal/rest/v1/social/attachments/%s/%s/%s", "containerBackground", objectId, attachment.getId());
    }

    private static ObjectAttachmentDetail saveAppBackgroundImage(long templateId, byte[] backgroundImageBytes, AttachmentService attachmentService, long userIdentityId) {
        File tempFile = null;
        try {
            tempFile = DatabindUtils.getIllustrationFile(backgroundImageBytes);
            String uploadId = "TemplateBackgroundImage" + RANDOM.nextLong();
            UploadResource uploadResource = new UploadResource(uploadId);
            uploadResource.setFileName(tempFile.getName());
            uploadResource.setMimeType("image/png");
            uploadResource.setStatus(1);
            uploadResource.setStoreLocation(tempFile.getPath());
            attachmentService.deleteAttachments("containerBackground", String.valueOf(templateId));
            UploadedAttachmentDetail uploadedAttachmentDetail = new UploadedAttachmentDetail(uploadResource);
            String objectId = "template_" + templateId + "_" + String.valueOf(UUID.randomUUID());
            attachmentService.saveAttachment(uploadedAttachmentDetail, "containerBackground", objectId, null, userIdentityId);
            ObjectAttachmentList attachmentList = attachmentService.getAttachments("containerBackground", objectId);
            if (attachmentList != null && CollectionUtils.isNotEmpty((Collection)attachmentList.getAttachments())) {
                ObjectAttachmentDetail objectAttachmentDetail = (ObjectAttachmentDetail)attachmentList.getAttachments().getFirst();
                return objectAttachmentDetail;
            }
            ObjectAttachmentDetail objectAttachmentDetail = null;
            return objectAttachmentDetail;
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Error while saving background Image as attachment for template '%s'", templateId), e);
        }
        finally {
            if (tempFile != null) {
                try {
                    Files.delete(tempFile.toPath());
                }
                catch (IOException e) {
                    tempFile.deleteOnExit();
                }
            }
        }
    }

    public static File getIllustrationFile(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Illustration data is null");
        }
        File tempFile = File.createTempFile("temp", ".png");
        FileUtils.writeByteArrayToFile((File)tempFile, (byte[])data);
        return tempFile;
    }
}

