/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.spring.liquibase;

import java.sql.SQLException;
import javax.sql.DataSource;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.integration.spring.SpringLiquibase;
import org.exoplatform.commons.persistence.impl.LiquibaseDataInitializer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={LiquibaseProperties.class})
public class LiquibaseIntegration {
    private static final Log LOG = ExoLogger.getLogger(LiquibaseIntegration.class);

    @Bean
    public SpringLiquibase liquibase(LiquibaseProperties liquibaseProperties) {
        LiquibaseDataInitializer liquibaseDataInitializer = (LiquibaseDataInitializer)PortalContainer.getInstance().getComponentInstanceOfType(LiquibaseDataInitializer.class);
        SpringLiquibase liquibase = new SpringLiquibase();
        DataSource datasource = liquibaseDataInitializer.getDatasource();
        liquibase.setDataSource(datasource);
        liquibase.setContexts(liquibaseDataInitializer.getContexts());
        String schema = this.getSchema(datasource, liquibaseProperties);
        liquibase.setDefaultSchema(schema);
        liquibase.setLiquibaseSchema(schema);
        liquibase.setChangeLog(liquibaseProperties.getChangeLog());
        liquibase.setDropFirst(liquibaseProperties.isDropFirst());
        liquibase.setShouldRun(liquibaseProperties.isEnabled());
        return liquibase;
    }

    private String getSchema(DataSource datasource, LiquibaseProperties liquibaseProperties) {
        String string;
        block8: {
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(datasource.getConnection()));
            try {
                string = database.getDefaultSchemaName();
                if (database == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (database != null) {
                        try {
                            database.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException | DatabaseException e) {
                    LOG.warn((Object)"Error while retrieving default schema name of datasource, attept to use default schema from settings 'spring.liquibase.default-schema'", e);
                    return liquibaseProperties.getDefaultSchema();
                }
            }
            database.close();
        }
        return string;
    }
}

