/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.GroupEventListener;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.MembershipEventListener;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipTypeEventListener;
import org.exoplatform.services.organization.MembershipTypeHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.OrganizationServiceInitializer;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserProfileEventListener;
import org.exoplatform.services.organization.UserProfileHandler;
import org.picocontainer.Startable;

public abstract class BaseOrganizationService
implements OrganizationService,
Startable,
ComponentRequestLifecycle {
    public static final Log LOG = ExoLogger.getLogger(BaseOrganizationService.class);
    protected UserHandler userDAO_;
    protected UserProfileHandler userProfileDAO_;
    protected GroupHandler groupDAO_;
    protected MembershipHandler membershipDAO_;
    protected MembershipTypeHandler membershipTypeDAO_;
    protected List<OrganizationServiceInitializer> listeners_ = new ArrayList<OrganizationServiceInitializer>();

    @Override
    public UserHandler getUserHandler() {
        return this.userDAO_;
    }

    @Override
    public UserProfileHandler getUserProfileHandler() {
        return this.userProfileDAO_;
    }

    @Override
    public GroupHandler getGroupHandler() {
        return this.groupDAO_;
    }

    @Override
    public MembershipTypeHandler getMembershipTypeHandler() {
        return this.membershipTypeDAO_;
    }

    @Override
    public MembershipHandler getMembershipHandler() {
        return this.membershipDAO_;
    }

    public void start() {
        RequestLifeCycle.begin((ComponentRequestLifecycle)this);
        try {
            this.init("groups");
            this.init("membershipTypes");
            this.init("users");
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    @Override
    public synchronized void addListenerPlugin(ComponentPlugin listener) throws Exception {
        if (listener instanceof UserEventListener) {
            UserEventListener eventListener = (UserEventListener)listener;
            this.userDAO_.addUserEventListener(eventListener);
        } else if (listener instanceof GroupEventListener) {
            GroupEventListener eventListener = (GroupEventListener)listener;
            this.groupDAO_.addGroupEventListener(eventListener);
        } else if (listener instanceof MembershipTypeEventListener) {
            MembershipTypeEventListener eventListener = (MembershipTypeEventListener)listener;
            this.membershipTypeDAO_.addMembershipTypeEventListener(eventListener);
        } else if (listener instanceof MembershipEventListener) {
            MembershipEventListener eventListener = (MembershipEventListener)listener;
            this.membershipDAO_.addMembershipEventListener(eventListener);
        } else if (listener instanceof UserProfileEventListener) {
            UserProfileEventListener eventListener = (UserProfileEventListener)listener;
            this.userProfileDAO_.addUserProfileEventListener(eventListener);
        } else if (listener instanceof OrganizationServiceInitializer) {
            OrganizationServiceInitializer initializer = (OrganizationServiceInitializer)listener;
            this.listeners_.add(initializer);
        }
    }

    public void startRequest(ExoContainer container) {
    }

    public void endRequest(ExoContainer container) {
    }

    private void init(String entityType) {
        for (OrganizationServiceInitializer listener : this.listeners_) {
            try {
                listener.init(this, entityType);
            }
            catch (Exception e) {
                LOG.warn("Failed start Organization Service {}, probably because of configuration error. Error occurs when initialize {}", new Object[]{this.getClass().getName(), listener.getClass().getName(), e});
            }
        }
    }
}

