/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.storage;

import io.meeds.layout.dao.PortletInstanceDAO;
import io.meeds.layout.entity.PortletInstanceEntity;
import io.meeds.layout.model.PortletInstance;
import io.meeds.layout.storage.PortletStorage;
import io.meeds.layout.util.EntityMapper;
import java.util.List;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PortletInstanceStorage {
    @Autowired
    private PortletStorage portletStorage;
    @Autowired
    private PortletInstanceDAO portletInstanceDAO;

    public List<PortletInstance> getPortletInstances() {
        List entities = this.portletInstanceDAO.findAll();
        return entities.stream().map(entity -> EntityMapper.fromEntity(entity, this.portletStorage.getPortletDescriptor(entity.getContentId()))).toList();
    }

    public List<PortletInstance> getPortletInstances(long categoryId) {
        List<PortletInstanceEntity> entities = this.portletInstanceDAO.findByCategoryId(categoryId);
        return entities.stream().map(entity -> EntityMapper.fromEntity(entity, this.portletStorage.getPortletDescriptor(entity.getContentId()))).toList();
    }

    public PortletInstance getPortletInstance(long id) {
        return this.portletInstanceDAO.findById(id).map(entity -> EntityMapper.fromEntity(entity, this.portletStorage.getPortletDescriptor(entity.getContentId()))).orElse(null);
    }

    public PortletInstance createPortletInstance(PortletInstance portletInstance) {
        return this.save(portletInstance);
    }

    public PortletInstance updatePortletInstance(PortletInstance portletInstance) throws ObjectNotFoundException {
        if (!this.portletInstanceDAO.existsById(portletInstance.getId())) {
            throw new ObjectNotFoundException("Entity doesn't exist");
        }
        return this.save(portletInstance);
    }

    public void deletePortletInstance(long id) throws ObjectNotFoundException {
        if (!this.portletInstanceDAO.existsById(id)) {
            throw new ObjectNotFoundException(String.format("Entity with id %s doesn't exist", id));
        }
        this.portletInstanceDAO.deleteById(id);
    }

    private PortletInstance save(PortletInstance portletInstance) {
        PortletInstanceEntity entity = EntityMapper.toEntity(portletInstance);
        entity = (PortletInstanceEntity)this.portletInstanceDAO.save(entity);
        return EntityMapper.fromEntity(entity, this.portletStorage.getPortletDescriptor(entity.getContentId()));
    }
}

