/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.ext.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.ext.UIExtension;
import org.exoplatform.webui.ext.UIExtensionManager;
import org.exoplatform.webui.ext.UIExtensionPlugin;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilterType;

public class UIExtensionManagerImpl
implements UIExtensionManager {
    private static final Log LOG = ExoLogger.getLogger(UIExtensionManagerImpl.class);
    private final ConcurrentMap<String, Map<String, UIExtension>> extensions = new ConcurrentHashMap<String, Map<String, UIExtension>>();

    @Override
    public boolean accept(String extensionType, String extensionName, Map<String, Object> context) {
        UIExtension extension = this.getUIExtension(extensionType, extensionName);
        if (extension != null) {
            return this.accept(extension, context, false);
        }
        LOG.warn((Object)("The extension type = " + extensionType + ", name = " + extensionName + " cannot be found"));
        return false;
    }

    @Override
    public UIComponent addUIExtension(String extensionType, String extensionName, Map<String, Object> context, UIContainer parent) throws Exception {
        UIExtension extension = this.getUIExtension(extensionType, extensionName);
        if (extension == null) {
            LOG.warn((Object)("The extension type = " + extensionType + ", name = " + extensionName + " cannot be found"));
        } else {
            String id = this.createComponentId(parent, extensionName);
            parent.removeChildById(id);
            if (this.accept(extension, context, true)) {
                UIComponent component = parent.createUIComponent(extension.getComponent(), null, id);
                parent.addChild(component);
                return component;
            }
        }
        return null;
    }

    @Override
    public UIComponent addUIExtension(UIExtension extension, Map<String, Object> context, UIContainer parent) throws Exception {
        return this.addUIExtension(extension.getType(), extension.getName(), context, parent);
    }

    @Override
    public void registerUIExtensionPlugin(UIExtensionPlugin extensionPlugin) {
        List<UIExtension> extensions = extensionPlugin.getExtensions();
        if (extensions != null) {
            for (UIExtension extension : extensions) {
                this.registerUIExtension(extension);
            }
        }
    }

    @Override
    public void registerUIExtension(UIExtension extension) {
        Map<String, UIExtension> extensions = this.getUIExtensions(extension.getType(), true);
        extensions.put(extension.getName(), extension);
    }

    @Override
    public List<UIExtension> getUIExtensions(String type) {
        Map<String, UIExtension> extensions = this.getUIExtensions(type, false);
        if (extensions != null) {
            ArrayList<UIExtension> lExtensions = new ArrayList<UIExtension>(extensions.values());
            Collections.sort(lExtensions);
            return lExtensions;
        }
        return null;
    }

    @Override
    public UIExtension getUIExtension(String type, String name) {
        Map<String, UIExtension> extensions = this.getUIExtensions(type, false);
        if (extensions != null) {
            return extensions.get(name);
        }
        return null;
    }

    private Map<String, UIExtension> getUIExtensions(String extensionType, boolean create) {
        Map mExtensions = (Map)this.extensions.get(extensionType);
        if (mExtensions == null && create) {
            this.extensions.putIfAbsent(extensionType, new ConcurrentHashMap());
            mExtensions = (Map)this.extensions.get(extensionType);
        }
        return mExtensions;
    }

    protected boolean accept(UIExtension extension, Map<String, Object> context, boolean checkOnly) {
        return this.accept(extension.getExtendedFilters(), context, checkOnly) && this.accept(extension.getComponentFilters(), context, checkOnly) && extension.isEnable();
    }

    protected String createComponentId(UIContainer parent, String extensionName) {
        StringBuilder sb = new StringBuilder(128);
        sb.append(parent.getId());
        sb.append('_');
        sb.append(extensionName);
        sb.append('_');
        return sb.toString();
    }

    private boolean accept(List<UIExtensionFilter> filters, Map<String, Object> context, boolean checkOnly) {
        boolean result = true;
        if (filters != null) {
            int length = filters.size();
            for (int i = 0; i < length; ++i) {
                UIExtensionFilter filter = filters.get(i);
                UIExtensionFilterType type = filter.getType();
                if (checkOnly && (type == null || !type.showExtensionOnlyIfOK())) continue;
                try {
                    if (filter.accept(context)) continue;
                    this.onDeny(checkOnly, filter, context);
                    if (type == null) continue;
                    if (type.checkOtherFiltersOnlyIfOK()) {
                        return false;
                    }
                    if (!type.acceptOnlyIfOK()) continue;
                    result = false;
                    continue;
                }
                catch (Exception e) {
                    LOG.error((Object)"An exeception occurs while applying the filter", (Throwable)e);
                    this.onDeny(checkOnly, filter, context);
                    if (type == null) continue;
                    if (type.checkOtherFiltersOnlyIfOK()) {
                        return false;
                    }
                    if (!type.acceptOnlyIfOK()) continue;
                    result = false;
                }
            }
        }
        return result;
    }

    private void onDeny(boolean checkOnly, UIExtensionFilter filter, Map<String, Object> context) {
        if (!checkOnly) {
            try {
                filter.onDeny(context);
            }
            catch (Exception e) {
                LOG.error((Object)"An execption occurs while calling the method onDeny of the filter", (Throwable)e);
            }
        }
    }
}

